// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * The application version lifecycle settings for an application. Defines the rules that Elastic Beanstalk applies to an application's versions in order to avoid hitting the per-region limit for application versions.
 *
 * When Elastic Beanstalk deletes an application version from its database, you can no longer deploy that version to an environment. The source bundle remains in S3 unless you configure the rule to delete it.
 */
public class ApplicationVersionLifecycleConfig private constructor(builder: Builder) {
    /**
     * Specify a max age rule to restrict the length of time that application versions are retained for an application.
     */
    public val maxAgeRule: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule? = builder.maxAgeRule
    /**
     * Specify a max count rule to restrict the number of application versions that are retained for an application.
     */
    public val maxCountRule: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule? = builder.maxCountRule

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationVersionLifecycleConfig(")
        append("maxAgeRule=$maxAgeRule,")
        append("maxCountRule=$maxCountRule")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxAgeRule?.hashCode() ?: 0
        result = 31 * result + (maxCountRule?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationVersionLifecycleConfig

        if (maxAgeRule != other.maxAgeRule) return false
        if (maxCountRule != other.maxCountRule) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify a max age rule to restrict the length of time that application versions are retained for an application.
         */
        public var maxAgeRule: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule? = null
        /**
         * Specify a max count rule to restrict the number of application versions that are retained for an application.
         */
        public var maxCountRule: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig) : this() {
            this.maxAgeRule = x.maxAgeRule
            this.maxCountRule = x.maxCountRule
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig = ApplicationVersionLifecycleConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule] inside the given [block]
         */
        public fun maxAgeRule(block: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule.Builder.() -> kotlin.Unit) {
            this.maxAgeRule = aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule] inside the given [block]
         */
        public fun maxCountRule(block: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule.Builder.() -> kotlin.Unit) {
            this.maxCountRule = aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
