// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Describes criteria to restrict the results when listing platform versions.
 *
 * The filter is evaluated as follows: `Type Operator Values[1]`
 */
public class PlatformFilter private constructor(builder: Builder) {
    /**
     * The operator to apply to the `Type` with each of the `Values`.
     *
     * Valid values: `=` | `!=` | `<` | `<=` | `>` | `>=` | `contains` | `begins_with` | `ends_with`
     */
    public val operator: kotlin.String? = builder.operator
    /**
     * The platform version attribute to which the filter values are applied.
     *
     * Valid values: `PlatformName` | `PlatformVersion` | `PlatformStatus` | `PlatformBranchName` | `PlatformLifecycleState` | `PlatformOwner` | `SupportedTier` | `SupportedAddon` | `ProgrammingLanguageName` | `OperatingSystemName`
     */
    public val type: kotlin.String? = builder.type
    /**
     * The list of values applied to the filtering platform version attribute. Only one value is supported for all current operators.
     *
     * The following list shows valid filter values for some filter attributes.
     * + `PlatformStatus`: `Creating` | `Failed` | `Ready` | `Deleting` | `Deleted`
     * + `PlatformLifecycleState`: `recommended`
     * + `SupportedTier`: `WebServer/Standard` | `Worker/SQS/HTTP`
     * + `SupportedAddon`: `Log/S3` | `Monitoring/Healthd` | `WorkerDaemon/SQSD`
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlatformFilter(")
        append("operator=$operator,")
        append("type=$type,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = operator?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlatformFilter

        if (operator != other.operator) return false
        if (type != other.type) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The operator to apply to the `Type` with each of the `Values`.
         *
         * Valid values: `=` | `!=` | `<` | `<=` | `>` | `>=` | `contains` | `begins_with` | `ends_with`
         */
        public var operator: kotlin.String? = null
        /**
         * The platform version attribute to which the filter values are applied.
         *
         * Valid values: `PlatformName` | `PlatformVersion` | `PlatformStatus` | `PlatformBranchName` | `PlatformLifecycleState` | `PlatformOwner` | `SupportedTier` | `SupportedAddon` | `ProgrammingLanguageName` | `OperatingSystemName`
         */
        public var type: kotlin.String? = null
        /**
         * The list of values applied to the filtering platform version attribute. Only one value is supported for all current operators.
         *
         * The following list shows valid filter values for some filter attributes.
         * + `PlatformStatus`: `Creating` | `Failed` | `Ready` | `Deleting` | `Deleted`
         * + `PlatformLifecycleState`: `recommended`
         * + `SupportedTier`: `WebServer/Standard` | `Worker/SQS/HTTP`
         * + `SupportedAddon`: `Log/S3` | `Monitoring/Healthd` | `WorkerDaemon/SQSD`
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformFilter) : this() {
            this.operator = x.operator
            this.type = x.type
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformFilter = PlatformFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
