// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Summary information about a platform branch.
 */
public class PlatformBranchSummary private constructor(builder: Builder) {
    /**
     * The name of the platform branch.
     */
    public val branchName: kotlin.String? = builder.branchName
    /**
     * An ordinal number that designates the order in which platform branches have been added to a platform. This can be helpful, for example, if your code calls the `ListPlatformBranches` action and then displays a list of platform branches.
     *
     * A larger `BranchOrder` value designates a newer platform branch within the platform.
     */
    public val branchOrder: kotlin.Int = builder.branchOrder
    /**
     * The support life cycle state of the platform branch.
     *
     * Possible values: `beta` | `supported` | `deprecated` | `retired`
     */
    public val lifecycleState: kotlin.String? = builder.lifecycleState
    /**
     * The name of the platform to which this platform branch belongs.
     */
    public val platformName: kotlin.String? = builder.platformName
    /**
     * The environment tiers that platform versions in this branch support.
     *
     * Possible values: `WebServer/Standard` | `Worker/SQS/HTTP`
     */
    public val supportedTierList: List<String>? = builder.supportedTierList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformBranchSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlatformBranchSummary(")
        append("branchName=$branchName,")
        append("branchOrder=$branchOrder,")
        append("lifecycleState=$lifecycleState,")
        append("platformName=$platformName,")
        append("supportedTierList=$supportedTierList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchName?.hashCode() ?: 0
        result = 31 * result + (branchOrder)
        result = 31 * result + (lifecycleState?.hashCode() ?: 0)
        result = 31 * result + (platformName?.hashCode() ?: 0)
        result = 31 * result + (supportedTierList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlatformBranchSummary

        if (branchName != other.branchName) return false
        if (branchOrder != other.branchOrder) return false
        if (lifecycleState != other.lifecycleState) return false
        if (platformName != other.platformName) return false
        if (supportedTierList != other.supportedTierList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformBranchSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the platform branch.
         */
        public var branchName: kotlin.String? = null
        /**
         * An ordinal number that designates the order in which platform branches have been added to a platform. This can be helpful, for example, if your code calls the `ListPlatformBranches` action and then displays a list of platform branches.
         *
         * A larger `BranchOrder` value designates a newer platform branch within the platform.
         */
        public var branchOrder: kotlin.Int = 0
        /**
         * The support life cycle state of the platform branch.
         *
         * Possible values: `beta` | `supported` | `deprecated` | `retired`
         */
        public var lifecycleState: kotlin.String? = null
        /**
         * The name of the platform to which this platform branch belongs.
         */
        public var platformName: kotlin.String? = null
        /**
         * The environment tiers that platform versions in this branch support.
         *
         * Possible values: `WebServer/Standard` | `Worker/SQS/HTTP`
         */
        public var supportedTierList: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformBranchSummary) : this() {
            this.branchName = x.branchName
            this.branchOrder = x.branchOrder
            this.lifecycleState = x.lifecycleState
            this.platformName = x.platformName
            this.supportedTierList = x.supportedTierList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformBranchSummary = PlatformBranchSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
