// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Settings for an AWS CodeBuild build.
 */
public class BuildConfiguration private constructor(builder: Builder) {
    /**
     * The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk stores the build artifact in the S3 location *S3-bucket*&#47;resources&#47;*application-name*&#47;codebuild/codebuild-*version-label*-*artifact-name*.zip. If not provided, Elastic Beanstalk stores the build artifact in the S3 location *S3-bucket*&#47;resources&#47;*application-name*&#47;codebuild/codebuild-*version-label*.zip.
     */
    public val artifactName: kotlin.String? = builder.artifactName
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    public val codeBuildServiceRole: kotlin.String = requireNotNull(builder.codeBuildServiceRole) { "A non-null value must be provided for codeBuildServiceRole" }
    /**
     * Information about the compute resources the build project will use.
     * + `BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds`
     * + `BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds`
     * + `BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds`
     */
    public val computeType: aws.sdk.kotlin.services.elasticbeanstalk.model.ComputeType? = builder.computeType
    /**
     * The ID of the Docker image to use for this build project.
     */
    public val image: kotlin.String = requireNotNull(builder.image) { "A non-null value must be provided for image" }
    /**
     * How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
     */
    public val timeoutInMinutes: kotlin.Int? = builder.timeoutInMinutes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BuildConfiguration(")
        append("artifactName=$artifactName,")
        append("codeBuildServiceRole=$codeBuildServiceRole,")
        append("computeType=$computeType,")
        append("image=$image,")
        append("timeoutInMinutes=$timeoutInMinutes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactName?.hashCode() ?: 0
        result = 31 * result + (codeBuildServiceRole.hashCode())
        result = 31 * result + (computeType?.hashCode() ?: 0)
        result = 31 * result + (image.hashCode())
        result = 31 * result + (timeoutInMinutes ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BuildConfiguration

        if (artifactName != other.artifactName) return false
        if (codeBuildServiceRole != other.codeBuildServiceRole) return false
        if (computeType != other.computeType) return false
        if (image != other.image) return false
        if (timeoutInMinutes != other.timeoutInMinutes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the artifact of the CodeBuild build. If provided, Elastic Beanstalk stores the build artifact in the S3 location *S3-bucket*&#47;resources&#47;*application-name*&#47;codebuild/codebuild-*version-label*-*artifact-name*.zip. If not provided, Elastic Beanstalk stores the build artifact in the S3 location *S3-bucket*&#47;resources&#47;*application-name*&#47;codebuild/codebuild-*version-label*.zip.
         */
        public var artifactName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
         */
        public var codeBuildServiceRole: kotlin.String? = null
        /**
         * Information about the compute resources the build project will use.
         * + `BUILD_GENERAL1_SMALL: Use up to 3 GB memory and 2 vCPUs for builds`
         * + `BUILD_GENERAL1_MEDIUM: Use up to 7 GB memory and 4 vCPUs for builds`
         * + `BUILD_GENERAL1_LARGE: Use up to 15 GB memory and 8 vCPUs for builds`
         */
        public var computeType: aws.sdk.kotlin.services.elasticbeanstalk.model.ComputeType? = null
        /**
         * The ID of the Docker image to use for this build project.
         */
        public var image: kotlin.String? = null
        /**
         * How long in minutes, from 5 to 480 (8 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes.
         */
        public var timeoutInMinutes: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration) : this() {
            this.artifactName = x.artifactName
            this.codeBuildServiceRole = x.codeBuildServiceRole
            this.computeType = x.computeType
            this.image = x.image
            this.timeoutInMinutes = x.timeoutInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration = BuildConfiguration(this)

        internal fun correctErrors(): Builder {
            if (codeBuildServiceRole == null) codeBuildServiceRole = ""
            if (image == null) image = ""
            return this
        }
    }
}
