// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Application request metrics for an AWS Elastic Beanstalk environment.
 */
public class ApplicationMetrics private constructor(builder: Builder) {
    /**
     * The amount of time that the metrics cover (usually 10 seconds). For example, you might have 5 requests (`request_count`) within the most recent time slice of 10 seconds (`duration`).
     */
    public val duration: kotlin.Int? = builder.duration
    /**
     * Represents the average latency for the slowest X percent of requests over the last 10 seconds. Latencies are in seconds with one millisecond resolution.
     */
    public val latency: aws.sdk.kotlin.services.elasticbeanstalk.model.Latency? = builder.latency
    /**
     * Average number of requests handled by the web server per second over the last 10 seconds.
     */
    public val requestCount: kotlin.Int = builder.requestCount
    /**
     * Represents the percentage of requests over the last 10 seconds that resulted in each type of status code response.
     */
    public val statusCodes: aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes? = builder.statusCodes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationMetrics(")
        append("duration=$duration,")
        append("latency=$latency,")
        append("requestCount=$requestCount,")
        append("statusCodes=$statusCodes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration ?: 0
        result = 31 * result + (latency?.hashCode() ?: 0)
        result = 31 * result + (requestCount)
        result = 31 * result + (statusCodes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationMetrics

        if (duration != other.duration) return false
        if (latency != other.latency) return false
        if (requestCount != other.requestCount) return false
        if (statusCodes != other.statusCodes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of time that the metrics cover (usually 10 seconds). For example, you might have 5 requests (`request_count`) within the most recent time slice of 10 seconds (`duration`).
         */
        public var duration: kotlin.Int? = null
        /**
         * Represents the average latency for the slowest X percent of requests over the last 10 seconds. Latencies are in seconds with one millisecond resolution.
         */
        public var latency: aws.sdk.kotlin.services.elasticbeanstalk.model.Latency? = null
        /**
         * Average number of requests handled by the web server per second over the last 10 seconds.
         */
        public var requestCount: kotlin.Int = 0
        /**
         * Represents the percentage of requests over the last 10 seconds that resulted in each type of status code response.
         */
        public var statusCodes: aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics) : this() {
            this.duration = x.duration
            this.latency = x.latency
            this.requestCount = x.requestCount
            this.statusCodes = x.statusCodes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics = ApplicationMetrics(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.Latency] inside the given [block]
         */
        public fun latency(block: aws.sdk.kotlin.services.elasticbeanstalk.model.Latency.Builder.() -> kotlin.Unit) {
            this.latency = aws.sdk.kotlin.services.elasticbeanstalk.model.Latency.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes] inside the given [block]
         */
        public fun statusCodes(block: aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes.Builder.() -> kotlin.Unit) {
            this.statusCodes = aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
