// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Request to update an environment.
 */
public class UpdateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The name of the application with which the environment is associated.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the environment to update.
     *
     * If no environment with this ID exists, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
     *
     * Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns `MissingRequiredParameter` error.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
     *
     * Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns `MissingRequiredParameter` error.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See [Environment Manifest (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html) for details.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.
     */
    public val optionSettings: List<ConfigurationOptionSetting>? = builder.optionSettings
    /**
     * A list of custom user-defined configuration options to remove from the configuration set for this environment.
     */
    public val optionsToRemove: List<OptionSpecification>? = builder.optionsToRemove
    /**
     * The ARN of the platform, if used.
     */
    public val platformArn: kotlin.String? = builder.platformArn
    /**
     * This specifies the platform version that the environment will run after the environment is updated.
     */
    public val solutionStackName: kotlin.String? = builder.solutionStackName
    /**
     * If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * This specifies the tier to use to update the environment.
     *
     * Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns `InvalidParameterValue` error.
     */
    public val tier: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier? = builder.tier
    /**
     * If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an `InvalidParameterValue` error.
     */
    public val versionLabel: kotlin.String? = builder.versionLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEnvironmentRequest(")
        append("applicationName=$applicationName,")
        append("description=$description,")
        append("environmentId=$environmentId,")
        append("environmentName=$environmentName,")
        append("groupName=$groupName,")
        append("optionSettings=$optionSettings,")
        append("optionsToRemove=$optionsToRemove,")
        append("platformArn=$platformArn,")
        append("solutionStackName=$solutionStackName,")
        append("templateName=$templateName,")
        append("tier=$tier,")
        append("versionLabel=$versionLabel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (optionSettings?.hashCode() ?: 0)
        result = 31 * result + (optionsToRemove?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (solutionStackName?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEnvironmentRequest

        if (applicationName != other.applicationName) return false
        if (description != other.description) return false
        if (environmentId != other.environmentId) return false
        if (environmentName != other.environmentName) return false
        if (groupName != other.groupName) return false
        if (optionSettings != other.optionSettings) return false
        if (optionsToRemove != other.optionsToRemove) return false
        if (platformArn != other.platformArn) return false
        if (solutionStackName != other.solutionStackName) return false
        if (templateName != other.templateName) return false
        if (tier != other.tier) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateEnvironmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application with which the environment is associated.
         */
        public var applicationName: kotlin.String? = null
        /**
         * If this parameter is specified, AWS Elastic Beanstalk updates the description of this environment.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the environment to update.
         *
         * If no environment with this ID exists, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
         *
         * Condition: You must specify either this or an EnvironmentName, or both. If you do not specify either, AWS Elastic Beanstalk returns `MissingRequiredParameter` error.
         */
        public var environmentId: kotlin.String? = null
        /**
         * The name of the environment to update. If no environment with this name exists, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
         *
         * Condition: You must specify either this or an EnvironmentId, or both. If you do not specify either, AWS Elastic Beanstalk returns `MissingRequiredParameter` error.
         */
        public var environmentName: kotlin.String? = null
        /**
         * The name of the group to which the target environment belongs. Specify a group name only if the environment's name is specified in an environment manifest and not with the environment name or environment ID parameters. See [Environment Manifest (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html) for details.
         */
        public var groupName: kotlin.String? = null
        /**
         * If specified, AWS Elastic Beanstalk updates the configuration set associated with the running environment and sets the specified configuration options to the requested value.
         */
        public var optionSettings: List<ConfigurationOptionSetting>? = null
        /**
         * A list of custom user-defined configuration options to remove from the configuration set for this environment.
         */
        public var optionsToRemove: List<OptionSpecification>? = null
        /**
         * The ARN of the platform, if used.
         */
        public var platformArn: kotlin.String? = null
        /**
         * This specifies the platform version that the environment will run after the environment is updated.
         */
        public var solutionStackName: kotlin.String? = null
        /**
         * If this parameter is specified, AWS Elastic Beanstalk deploys this configuration template to the environment. If no such configuration template is found, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
         */
        public var templateName: kotlin.String? = null
        /**
         * This specifies the tier to use to update the environment.
         *
         * Condition: At this time, if you change the tier version, name, or type, AWS Elastic Beanstalk returns `InvalidParameterValue` error.
         */
        public var tier: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier? = null
        /**
         * If this parameter is specified, AWS Elastic Beanstalk deploys the named application version to the environment. If no such application version is found, returns an `InvalidParameterValue` error.
         */
        public var versionLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateEnvironmentRequest) : this() {
            this.applicationName = x.applicationName
            this.description = x.description
            this.environmentId = x.environmentId
            this.environmentName = x.environmentName
            this.groupName = x.groupName
            this.optionSettings = x.optionSettings
            this.optionsToRemove = x.optionsToRemove
            this.platformArn = x.platformArn
            this.solutionStackName = x.solutionStackName
            this.templateName = x.templateName
            this.tier = x.tier
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateEnvironmentRequest = UpdateEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier] inside the given [block]
         */
        public fun tier(block: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier.Builder.() -> kotlin.Unit) {
            this.tier = aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier.invoke(block)
        }
    }
}
