// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Request to describe one or more environments.
 */
public class DescribeEnvironmentsRequest private constructor(builder: Builder) {
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.
     */
    public val environmentIds: List<String>? = builder.environmentIds
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.
     */
    public val environmentNames: List<String>? = builder.environmentNames
    /**
     * Indicates whether to include deleted environments:
     *
     * `true`: Environments that have been deleted after `IncludedDeletedBackTo` are displayed.
     *
     * `false`: Do not include deleted environments.
     */
    public val includeDeleted: kotlin.Boolean? = builder.includeDeleted
    /**
     * If specified when `IncludeDeleted` is set to `true`, then environments deleted after this date are displayed.
     */
    public val includedDeletedBackTo: aws.smithy.kotlin.runtime.time.Instant? = builder.includedDeletedBackTo
    /**
     * For a paginated request. Specify a maximum number of environments to include in each response.
     *
     * If no `MaxRecords` is specified, all available environments are retrieved in a single response.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.
     *
     * If no `NextToken` is specified, the first page is retrieved.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.
     */
    public val versionLabel: kotlin.String? = builder.versionLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEnvironmentsRequest(")
        append("applicationName=$applicationName,")
        append("environmentIds=$environmentIds,")
        append("environmentNames=$environmentNames,")
        append("includeDeleted=$includeDeleted,")
        append("includedDeletedBackTo=$includedDeletedBackTo,")
        append("maxRecords=$maxRecords,")
        append("nextToken=$nextToken,")
        append("versionLabel=$versionLabel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (environmentIds?.hashCode() ?: 0)
        result = 31 * result + (environmentNames?.hashCode() ?: 0)
        result = 31 * result + (includeDeleted?.hashCode() ?: 0)
        result = 31 * result + (includedDeletedBackTo?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEnvironmentsRequest

        if (applicationName != other.applicationName) return false
        if (environmentIds != other.environmentIds) return false
        if (environmentNames != other.environmentNames) return false
        if (includeDeleted != other.includeDeleted) return false
        if (includedDeletedBackTo != other.includedDeletedBackTo) return false
        if (maxRecords != other.maxRecords) return false
        if (nextToken != other.nextToken) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application.
         */
        public var applicationName: kotlin.String? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified IDs.
         */
        public var environmentIds: List<String>? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that have the specified names.
         */
        public var environmentNames: List<String>? = null
        /**
         * Indicates whether to include deleted environments:
         *
         * `true`: Environments that have been deleted after `IncludedDeletedBackTo` are displayed.
         *
         * `false`: Do not include deleted environments.
         */
        public var includeDeleted: kotlin.Boolean? = null
        /**
         * If specified when `IncludeDeleted` is set to `true`, then environments deleted after this date are displayed.
         */
        public var includedDeletedBackTo: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * For a paginated request. Specify a maximum number of environments to include in each response.
         *
         * If no `MaxRecords` is specified, all available environments are retrieved in a single response.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.
         *
         * If no `NextToken` is specified, the first page is retrieved.
         */
        public var nextToken: kotlin.String? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only those that are associated with this application version.
         */
        public var versionLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsRequest) : this() {
            this.applicationName = x.applicationName
            this.environmentIds = x.environmentIds
            this.environmentNames = x.environmentNames
            this.includeDeleted = x.includeDeleted
            this.includedDeletedBackTo = x.includedDeletedBackTo
            this.maxRecords = x.maxRecords
            this.nextToken = x.nextToken
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsRequest = DescribeEnvironmentsRequest(this)
    }
}
