// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Result message containing a list of application version descriptions.
 */
public class DescribeConfigurationOptionsRequest private constructor(builder: Builder) {
    /**
     * The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * The name of the environment whose configuration options you want to describe.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * If specified, restricts the descriptions to only the specified options.
     */
    public val options: List<OptionSpecification>? = builder.options
    /**
     * The ARN of the custom platform.
     */
    public val platformArn: kotlin.String? = builder.platformArn
    /**
     * The name of the solution stack whose configuration options you want to describe.
     */
    public val solutionStackName: kotlin.String? = builder.solutionStackName
    /**
     * The name of the configuration template whose configuration options you want to describe.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeConfigurationOptionsRequest(")
        append("applicationName=$applicationName,")
        append("environmentName=$environmentName,")
        append("options=$options,")
        append("platformArn=$platformArn,")
        append("solutionStackName=$solutionStackName,")
        append("templateName=$templateName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (solutionStackName?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeConfigurationOptionsRequest

        if (applicationName != other.applicationName) return false
        if (environmentName != other.environmentName) return false
        if (options != other.options) return false
        if (platformArn != other.platformArn) return false
        if (solutionStackName != other.solutionStackName) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application associated with the configuration template or environment. Only needed if you want to describe the configuration options associated with either the configuration template or environment.
         */
        public var applicationName: kotlin.String? = null
        /**
         * The name of the environment whose configuration options you want to describe.
         */
        public var environmentName: kotlin.String? = null
        /**
         * If specified, restricts the descriptions to only the specified options.
         */
        public var options: List<OptionSpecification>? = null
        /**
         * The ARN of the custom platform.
         */
        public var platformArn: kotlin.String? = null
        /**
         * The name of the solution stack whose configuration options you want to describe.
         */
        public var solutionStackName: kotlin.String? = null
        /**
         * The name of the configuration template whose configuration options you want to describe.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest) : this() {
            this.applicationName = x.applicationName
            this.environmentName = x.environmentName
            this.options = x.options
            this.platformArn = x.platformArn
            this.solutionStackName = x.solutionStackName
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest = DescribeConfigurationOptionsRequest(this)
    }
}
