// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the settings for a configuration set.
 */
public class CreateConfigurationTemplateResponse private constructor(builder: Builder) {
    /**
     * The name of the application associated with this configuration set.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * The date (in UTC time) when this configuration set was created.
     */
    public val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The date (in UTC time) when this configuration set was last modified.
     */
    public val dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateUpdated
    /**
     * If this configuration set is associated with an environment, the `DeploymentStatus` parameter indicates the deployment status of this configuration set:
     * + `null`: This configuration is not associated with a running environment.
     * + `pending`: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.
     * + `deployed`: This is the configuration that is currently deployed to the associated running environment.
     * + `failed`: This is a draft configuration that failed to successfully deploy.
     */
    public val deploymentStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationDeploymentStatus? = builder.deploymentStatus
    /**
     * Describes this configuration set.
     */
    public val description: kotlin.String? = builder.description
    /**
     * If not `null`, the name of the environment for this configuration set.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * A list of the configuration options and their values in this configuration set.
     */
    public val optionSettings: List<ConfigurationOptionSetting>? = builder.optionSettings
    /**
     * The ARN of the platform version.
     */
    public val platformArn: kotlin.String? = builder.platformArn
    /**
     * The name of the solution stack this configuration set uses.
     */
    public val solutionStackName: kotlin.String? = builder.solutionStackName
    /**
     * If not `null`, the name of the configuration template for this configuration set.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfigurationTemplateResponse(")
        append("applicationName=$applicationName,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("deploymentStatus=$deploymentStatus,")
        append("description=$description,")
        append("environmentName=$environmentName,")
        append("optionSettings=$optionSettings,")
        append("platformArn=$platformArn,")
        append("solutionStackName=$solutionStackName,")
        append("templateName=$templateName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (deploymentStatus?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (optionSettings?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (solutionStackName?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConfigurationTemplateResponse

        if (applicationName != other.applicationName) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (deploymentStatus != other.deploymentStatus) return false
        if (description != other.description) return false
        if (environmentName != other.environmentName) return false
        if (optionSettings != other.optionSettings) return false
        if (platformArn != other.platformArn) return false
        if (solutionStackName != other.solutionStackName) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application associated with this configuration set.
         */
        public var applicationName: kotlin.String? = null
        /**
         * The date (in UTC time) when this configuration set was created.
         */
        public var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date (in UTC time) when this configuration set was last modified.
         */
        public var dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If this configuration set is associated with an environment, the `DeploymentStatus` parameter indicates the deployment status of this configuration set:
         * + `null`: This configuration is not associated with a running environment.
         * + `pending`: This is a draft configuration that is not deployed to the associated environment but is in the process of deploying.
         * + `deployed`: This is the configuration that is currently deployed to the associated running environment.
         * + `failed`: This is a draft configuration that failed to successfully deploy.
         */
        public var deploymentStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationDeploymentStatus? = null
        /**
         * Describes this configuration set.
         */
        public var description: kotlin.String? = null
        /**
         * If not `null`, the name of the environment for this configuration set.
         */
        public var environmentName: kotlin.String? = null
        /**
         * A list of the configuration options and their values in this configuration set.
         */
        public var optionSettings: List<ConfigurationOptionSetting>? = null
        /**
         * The ARN of the platform version.
         */
        public var platformArn: kotlin.String? = null
        /**
         * The name of the solution stack this configuration set uses.
         */
        public var solutionStackName: kotlin.String? = null
        /**
         * If not `null`, the name of the configuration template for this configuration set.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse) : this() {
            this.applicationName = x.applicationName
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.deploymentStatus = x.deploymentStatus
            this.description = x.description
            this.environmentName = x.environmentName
            this.optionSettings = x.optionSettings
            this.platformArn = x.platformArn
            this.solutionStackName = x.solutionStackName
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse = CreateConfigurationTemplateResponse(this)
    }
}
