// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.ManagedAction
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeEnvironmentManagedActionsOperationDeserializer: HttpDeserialize<DescribeEnvironmentManagedActionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeEnvironmentManagedActionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEnvironmentManagedActionsError(context, call)
        }
        val builder = DescribeEnvironmentManagedActionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEnvironmentManagedActionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEnvironmentManagedActionsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ElasticBeanstalkServiceException" -> ElasticBeanstalkServiceExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEnvironmentManagedActionsOperationBody(builder: DescribeEnvironmentManagedActionsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeEnvironmentManagedActionsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeEnvironmentManagedActionsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeEnvironmentManagedActions response")
    }
    // end unwrap response wrapper

    val MANAGEDACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ManagedActions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticbeanstalk.amazonaws.com/docs/2010-12-01/"))
        trait(XmlSerialName("DescribeEnvironmentManagedActionsResult"))
        field(MANAGEDACTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MANAGEDACTIONS_DESCRIPTOR.index -> builder.managedActions =
                    deserializer.deserializeList(MANAGEDACTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ManagedAction>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeManagedActionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
