// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.paginators

import aws.sdk.kotlin.services.elasticbeanstalk.ElasticBeanstalkClient
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.EventDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformBranchesRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformBranchesResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformVersionsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformVersionsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ManagedActionHistoryItem
import aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeEnvironmentManagedActionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEnvironmentManagedActionHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEnvironmentManagedActionHistoryResponse]
 */
public fun ElasticBeanstalkClient.describeEnvironmentManagedActionHistoryPaginated(initialRequest: DescribeEnvironmentManagedActionHistoryRequest): Flow<DescribeEnvironmentManagedActionHistoryResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEnvironmentManagedActionHistoryPaginated.describeEnvironmentManagedActionHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEnvironmentManagedActionHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEnvironmentManagedActionHistoryResponse]
 */
public fun ElasticBeanstalkClient.describeEnvironmentManagedActionHistoryPaginated(block: DescribeEnvironmentManagedActionHistoryRequest.Builder.() -> Unit): Flow<DescribeEnvironmentManagedActionHistoryResponse> =
    describeEnvironmentManagedActionHistoryPaginated(DescribeEnvironmentManagedActionHistoryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEnvironmentManagedActionHistoryPaginated]
 * to access the nested member [ManagedActionHistoryItem]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ManagedActionHistoryItem]
 */
@JvmName("describeEnvironmentManagedActionHistoryResponseManagedActionHistoryItem")
public fun Flow<DescribeEnvironmentManagedActionHistoryResponse>.managedActionHistoryItems(): Flow<ManagedActionHistoryItem> =
    transform() { response ->
        response.managedActionHistoryItems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun ElasticBeanstalkClient.describeEventsPaginated(initialRequest: DescribeEventsRequest): Flow<DescribeEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEventsPaginated.describeEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun ElasticBeanstalkClient.describeEventsPaginated(block: DescribeEventsRequest.Builder.() -> Unit): Flow<DescribeEventsResponse> =
    describeEventsPaginated(DescribeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsPaginated]
 * to access the nested member [EventDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventDescription]
 */
@JvmName("describeEventsResponseEventDescription")
public fun Flow<DescribeEventsResponse>.events(): Flow<EventDescription> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPlatformBranchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPlatformBranchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlatformBranchesResponse]
 */
public fun ElasticBeanstalkClient.listPlatformBranchesPaginated(initialRequest: ListPlatformBranchesRequest): Flow<ListPlatformBranchesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPlatformBranchesPaginated.listPlatformBranches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPlatformBranchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlatformBranchesResponse]
 */
public fun ElasticBeanstalkClient.listPlatformBranchesPaginated(block: ListPlatformBranchesRequest.Builder.() -> Unit): Flow<ListPlatformBranchesResponse> =
    listPlatformBranchesPaginated(ListPlatformBranchesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPlatformVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPlatformVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlatformVersionsResponse]
 */
public fun ElasticBeanstalkClient.listPlatformVersionsPaginated(initialRequest: ListPlatformVersionsRequest): Flow<ListPlatformVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPlatformVersionsPaginated.listPlatformVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPlatformVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPlatformVersionsResponse]
 */
public fun ElasticBeanstalkClient.listPlatformVersionsPaginated(block: ListPlatformVersionsRequest.Builder.() -> Unit): Flow<ListPlatformVersionsResponse> =
    listPlatformVersionsPaginated(ListPlatformVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPlatformVersionsPaginated]
 * to access the nested member [PlatformSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PlatformSummary]
 */
@JvmName("listPlatformVersionsResponsePlatformSummary")
public fun Flow<ListPlatformVersionsResponse>.platformSummaryList(): Flow<PlatformSummary> =
    transform() { response ->
        response.platformSummaryList?.forEach {
            emit(it)
        }
    }
