// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * A list of validation messages for a specified configuration template.
 */
public class ValidateConfigurationSettingsRequest private constructor(builder: Builder) {
    /**
     * The name of the application that the configuration template or environment belongs to.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * The name of the environment to validate the settings against.
     *
     * Condition: You cannot specify both this and a configuration template name.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * A list of the options and desired values to evaluate.
     */
    public val optionSettings: List<ConfigurationOptionSetting>? = builder.optionSettings
    /**
     * The name of the configuration template to validate the settings against.
     *
     * Condition: You cannot specify both this and an environment name.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidateConfigurationSettingsRequest(")
        append("applicationName=$applicationName,")
        append("environmentName=$environmentName,")
        append("optionSettings=$optionSettings,")
        append("templateName=$templateName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (optionSettings?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidateConfigurationSettingsRequest

        if (applicationName != other.applicationName) return false
        if (environmentName != other.environmentName) return false
        if (optionSettings != other.optionSettings) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application that the configuration template or environment belongs to.
         */
        public var applicationName: kotlin.String? = null
        /**
         * The name of the environment to validate the settings against.
         *
         * Condition: You cannot specify both this and a configuration template name.
         */
        public var environmentName: kotlin.String? = null
        /**
         * A list of the options and desired values to evaluate.
         */
        public var optionSettings: List<ConfigurationOptionSetting>? = null
        /**
         * The name of the configuration template to validate the settings against.
         *
         * Condition: You cannot specify both this and an environment name.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest) : this() {
            this.applicationName = x.applicationName
            this.environmentName = x.environmentName
            this.optionSettings = x.optionSettings
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest = ValidateConfigurationSettingsRequest(this)
    }
}
