// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * The result message containing the options for the specified solution stack.
 */
public class UpdateConfigurationTemplateRequest private constructor(builder: Builder) {
    /**
     * The name of the application associated with the configuration template to update.
     *
     *  If no application is found with this name, `UpdateConfigurationTemplate` returns an `InvalidParameterValue` error.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * A new description for the configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A list of configuration option settings to update with the new specified option value.
     */
    public val optionSettings: List<ConfigurationOptionSetting>? = builder.optionSettings
    /**
     * A list of configuration options to remove from the configuration set.
     *
     *  Constraint: You can remove only `UserDefined` configuration options.
     */
    public val optionsToRemove: List<OptionSpecification>? = builder.optionsToRemove
    /**
     * The name of the configuration template to update.
     *
     *  If no configuration template is found with this name, `UpdateConfigurationTemplate` returns an `InvalidParameterValue` error.
     */
    public val templateName: kotlin.String? = builder.templateName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConfigurationTemplateRequest(")
        append("applicationName=$applicationName,")
        append("description=$description,")
        append("optionSettings=$optionSettings,")
        append("optionsToRemove=$optionsToRemove,")
        append("templateName=$templateName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (optionSettings?.hashCode() ?: 0)
        result = 31 * result + (optionsToRemove?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConfigurationTemplateRequest

        if (applicationName != other.applicationName) return false
        if (description != other.description) return false
        if (optionSettings != other.optionSettings) return false
        if (optionsToRemove != other.optionsToRemove) return false
        if (templateName != other.templateName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application associated with the configuration template to update.
         *
         *  If no application is found with this name, `UpdateConfigurationTemplate` returns an `InvalidParameterValue` error.
         */
        public var applicationName: kotlin.String? = null
        /**
         * A new description for the configuration.
         */
        public var description: kotlin.String? = null
        /**
         * A list of configuration option settings to update with the new specified option value.
         */
        public var optionSettings: List<ConfigurationOptionSetting>? = null
        /**
         * A list of configuration options to remove from the configuration set.
         *
         *  Constraint: You can remove only `UserDefined` configuration options.
         */
        public var optionsToRemove: List<OptionSpecification>? = null
        /**
         * The name of the configuration template to update.
         *
         *  If no configuration template is found with this name, `UpdateConfigurationTemplate` returns an `InvalidParameterValue` error.
         */
        public var templateName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest) : this() {
            this.applicationName = x.applicationName
            this.description = x.description
            this.optionSettings = x.optionSettings
            this.optionsToRemove = x.optionsToRemove
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest = UpdateConfigurationTemplateRequest(this)
    }
}
