// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the properties of an environment.
 */
public class TerminateEnvironmentResponse private constructor(builder: Builder) {
    /**
     * Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.
     *
     * `true:` There is an update in progress.
     *
     * `false:` There are no updates currently in progress.
     */
    public val abortableOperationInProgress: kotlin.Boolean? = builder.abortableOperationInProgress
    /**
     * The name of the application associated with this environment.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * The URL to the CNAME for this environment.
     */
    public val cname: kotlin.String? = builder.cname
    /**
     * The creation date for this environment.
     */
    public val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The last modified date for this environment.
     */
    public val dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateUpdated
    /**
     * Describes this environment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.
     */
    public val endpointUrl: kotlin.String? = builder.endpointUrl
    /**
     * The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.
     */
    public val environmentArn: kotlin.String? = builder.environmentArn
    /**
     * The ID of this environment.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * A list of links to other environments in the same group.
     */
    public val environmentLinks: List<EnvironmentLink>? = builder.environmentLinks
    /**
     * The name of this environment.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:
     * + `Red`: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.
     * + `Yellow`: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.
     * + `Green`: Indicates the environment is healthy and fully functional.
     * + `Grey`: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an `UpdateEnvironment` or `RestartEnvironment` request.
     *
     *  Default: `Grey`
     */
    public val health: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth? = builder.health
    /**
     * Returns the health status of the application running in your environment. For more information, see [Health Colors and Statuses](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
     */
    public val healthStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealthStatus? = builder.healthStatus
    /**
     * The Amazon Resource Name (ARN) of the environment's operations role. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
     */
    public val operationsRole: kotlin.String? = builder.operationsRole
    /**
     * The ARN of the platform version.
     */
    public val platformArn: kotlin.String? = builder.platformArn
    /**
     * The description of the AWS resources used by this environment.
     */
    public val resources: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription? = builder.resources
    /**
     * The name of the `SolutionStack` deployed with this environment.
     */
    public val solutionStackName: kotlin.String? = builder.solutionStackName
    /**
     * The current operational status of the environment:
     * + `Launching`: Environment is in the process of initial deployment.
     * + `Updating`: Environment is in the process of updating its configuration settings or application version.
     * + `Ready`: Environment is available to have an action performed on it, such as update or terminate.
     * + `Terminating`: Environment is in the shut-down process.
     * + `Terminated`: Environment is not running.
     */
    public val status: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentStatus? = builder.status
    /**
     * The name of the configuration template used to originally launch this environment.
     */
    public val templateName: kotlin.String? = builder.templateName
    /**
     * Describes the current tier of this environment.
     */
    public val tier: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier? = builder.tier
    /**
     * The application version deployed in this environment.
     */
    public val versionLabel: kotlin.String? = builder.versionLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TerminateEnvironmentResponse(")
        append("abortableOperationInProgress=$abortableOperationInProgress,")
        append("applicationName=$applicationName,")
        append("cname=$cname,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("endpointUrl=$endpointUrl,")
        append("environmentArn=$environmentArn,")
        append("environmentId=$environmentId,")
        append("environmentLinks=$environmentLinks,")
        append("environmentName=$environmentName,")
        append("health=$health,")
        append("healthStatus=$healthStatus,")
        append("operationsRole=$operationsRole,")
        append("platformArn=$platformArn,")
        append("resources=$resources,")
        append("solutionStackName=$solutionStackName,")
        append("status=$status,")
        append("templateName=$templateName,")
        append("tier=$tier,")
        append("versionLabel=$versionLabel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortableOperationInProgress?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (cname?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpointUrl?.hashCode() ?: 0)
        result = 31 * result + (environmentArn?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (environmentLinks?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (operationsRole?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (solutionStackName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TerminateEnvironmentResponse

        if (abortableOperationInProgress != other.abortableOperationInProgress) return false
        if (applicationName != other.applicationName) return false
        if (cname != other.cname) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (endpointUrl != other.endpointUrl) return false
        if (environmentArn != other.environmentArn) return false
        if (environmentId != other.environmentId) return false
        if (environmentLinks != other.environmentLinks) return false
        if (environmentName != other.environmentName) return false
        if (health != other.health) return false
        if (healthStatus != other.healthStatus) return false
        if (operationsRole != other.operationsRole) return false
        if (platformArn != other.platformArn) return false
        if (resources != other.resources) return false
        if (solutionStackName != other.solutionStackName) return false
        if (status != other.status) return false
        if (templateName != other.templateName) return false
        if (tier != other.tier) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.
         *
         * `true:` There is an update in progress.
         *
         * `false:` There are no updates currently in progress.
         */
        public var abortableOperationInProgress: kotlin.Boolean? = null
        /**
         * The name of the application associated with this environment.
         */
        public var applicationName: kotlin.String? = null
        /**
         * The URL to the CNAME for this environment.
         */
        public var cname: kotlin.String? = null
        /**
         * The creation date for this environment.
         */
        public var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last modified date for this environment.
         */
        public var dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes this environment.
         */
        public var description: kotlin.String? = null
        /**
         * For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.
         */
        public var endpointUrl: kotlin.String? = null
        /**
         * The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.
         */
        public var environmentArn: kotlin.String? = null
        /**
         * The ID of this environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * A list of links to other environments in the same group.
         */
        public var environmentLinks: List<EnvironmentLink>? = null
        /**
         * The name of this environment.
         */
        public var environmentName: kotlin.String? = null
        /**
         * Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:
         * + `Red`: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.
         * + `Yellow`: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.
         * + `Green`: Indicates the environment is healthy and fully functional.
         * + `Grey`: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an `UpdateEnvironment` or `RestartEnvironment` request.
         *
         *  Default: `Grey`
         */
        public var health: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth? = null
        /**
         * Returns the health status of the application running in your environment. For more information, see [Health Colors and Statuses](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
         */
        public var healthStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealthStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the environment's operations role. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
         */
        public var operationsRole: kotlin.String? = null
        /**
         * The ARN of the platform version.
         */
        public var platformArn: kotlin.String? = null
        /**
         * The description of the AWS resources used by this environment.
         */
        public var resources: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription? = null
        /**
         * The name of the `SolutionStack` deployed with this environment.
         */
        public var solutionStackName: kotlin.String? = null
        /**
         * The current operational status of the environment:
         * + `Launching`: Environment is in the process of initial deployment.
         * + `Updating`: Environment is in the process of updating its configuration settings or application version.
         * + `Ready`: Environment is available to have an action performed on it, such as update or terminate.
         * + `Terminating`: Environment is in the shut-down process.
         * + `Terminated`: Environment is not running.
         */
        public var status: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentStatus? = null
        /**
         * The name of the configuration template used to originally launch this environment.
         */
        public var templateName: kotlin.String? = null
        /**
         * Describes the current tier of this environment.
         */
        public var tier: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier? = null
        /**
         * The application version deployed in this environment.
         */
        public var versionLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentResponse) : this() {
            this.abortableOperationInProgress = x.abortableOperationInProgress
            this.applicationName = x.applicationName
            this.cname = x.cname
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.endpointUrl = x.endpointUrl
            this.environmentArn = x.environmentArn
            this.environmentId = x.environmentId
            this.environmentLinks = x.environmentLinks
            this.environmentName = x.environmentName
            this.health = x.health
            this.healthStatus = x.healthStatus
            this.operationsRole = x.operationsRole
            this.platformArn = x.platformArn
            this.resources = x.resources
            this.solutionStackName = x.solutionStackName
            this.status = x.status
            this.templateName = x.templateName
            this.tier = x.tier
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentResponse = TerminateEnvironmentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier] inside the given [block]
         */
        public fun tier(block: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier.Builder.() -> kotlin.Unit) {
            this.tier = aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier.invoke(block)
        }
    }
}
