// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 *
 */
public class CreateApplicationVersionRequest private constructor(builder: Builder) {
    /**
     * The name of the application. If no application is found with this name, and `AutoCreateApplication` is `false`, returns an `InvalidParameterValue` error.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * Set to `true` to create an application with the specified name if it doesn't already exist.
     */
    public val autoCreateApplication: kotlin.Boolean? = builder.autoCreateApplication
    /**
     * Settings for an AWS CodeBuild build.
     */
    public val buildConfiguration: aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration? = builder.buildConfiguration
    /**
     * A description of this application version.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Pre-processes and validates the environment manifest (`env.yaml`) and configuration files (`*.config` files in the `.ebextensions` folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.
     *
     * You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.
     *
     * The `Process` option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.
     */
    public val process: kotlin.Boolean? = builder.process
    /**
     * Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.
     */
    public val sourceBuildInformation: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation? = builder.sourceBuildInformation
    /**
     * The Amazon S3 bucket and key that identify the location of the source bundle for this version.
     *
     * The Amazon S3 bucket must be in the same region as the environment.
     *
     * Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with `SourceBuildInformation`), but not both. If neither `SourceBundle` nor `SourceBuildInformation` are provided, Elastic Beanstalk uses a sample application.
     */
    public val sourceBundle: aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location? = builder.sourceBundle
    /**
     * Specifies the tags applied to the application version.
     *
     * Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A label identifying this version.
     *
     * Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
     */
    public val versionLabel: kotlin.String? = builder.versionLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationVersionRequest(")
        append("applicationName=$applicationName,")
        append("autoCreateApplication=$autoCreateApplication,")
        append("buildConfiguration=$buildConfiguration,")
        append("description=$description,")
        append("process=$process,")
        append("sourceBuildInformation=$sourceBuildInformation,")
        append("sourceBundle=$sourceBundle,")
        append("tags=$tags,")
        append("versionLabel=$versionLabel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (autoCreateApplication?.hashCode() ?: 0)
        result = 31 * result + (buildConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (process?.hashCode() ?: 0)
        result = 31 * result + (sourceBuildInformation?.hashCode() ?: 0)
        result = 31 * result + (sourceBundle?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApplicationVersionRequest

        if (applicationName != other.applicationName) return false
        if (autoCreateApplication != other.autoCreateApplication) return false
        if (buildConfiguration != other.buildConfiguration) return false
        if (description != other.description) return false
        if (process != other.process) return false
        if (sourceBuildInformation != other.sourceBuildInformation) return false
        if (sourceBundle != other.sourceBundle) return false
        if (tags != other.tags) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application. If no application is found with this name, and `AutoCreateApplication` is `false`, returns an `InvalidParameterValue` error.
         */
        public var applicationName: kotlin.String? = null
        /**
         * Set to `true` to create an application with the specified name if it doesn't already exist.
         */
        public var autoCreateApplication: kotlin.Boolean? = null
        /**
         * Settings for an AWS CodeBuild build.
         */
        public var buildConfiguration: aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration? = null
        /**
         * A description of this application version.
         */
        public var description: kotlin.String? = null
        /**
         * Pre-processes and validates the environment manifest (`env.yaml`) and configuration files (`*.config` files in the `.ebextensions` folder) in the source bundle. Validating configuration files can identify issues prior to deploying the application version to an environment.
         *
         * You must turn processing on for application versions that you create using AWS CodeBuild or AWS CodeCommit. For application versions built from a source bundle in Amazon S3, processing is optional.
         *
         * The `Process` option validates Elastic Beanstalk configuration files. It doesn't validate your application's configuration files, like proxy server or Docker configuration.
         */
        public var process: kotlin.Boolean? = null
        /**
         * Specify a commit in an AWS CodeCommit Git repository to use as the source code for the application version.
         */
        public var sourceBuildInformation: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation? = null
        /**
         * The Amazon S3 bucket and key that identify the location of the source bundle for this version.
         *
         * The Amazon S3 bucket must be in the same region as the environment.
         *
         * Specify a source bundle in S3 or a commit in an AWS CodeCommit repository (with `SourceBuildInformation`), but not both. If neither `SourceBundle` nor `SourceBuildInformation` are provided, Elastic Beanstalk uses a sample application.
         */
        public var sourceBundle: aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location? = null
        /**
         * Specifies the tags applied to the application version.
         *
         * Elastic Beanstalk applies these tags only to the application version. Environments that use the application version don't inherit the tags.
         */
        public var tags: List<Tag>? = null
        /**
         * A label identifying this version.
         *
         * Constraint: Must be unique per application. If an application version already exists with this label for the specified application, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
         */
        public var versionLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionRequest) : this() {
            this.applicationName = x.applicationName
            this.autoCreateApplication = x.autoCreateApplication
            this.buildConfiguration = x.buildConfiguration
            this.description = x.description
            this.process = x.process
            this.sourceBuildInformation = x.sourceBuildInformation
            this.sourceBundle = x.sourceBundle
            this.tags = x.tags
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionRequest = CreateApplicationVersionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration] inside the given [block]
         */
        public fun buildConfiguration(block: aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration.Builder.() -> kotlin.Unit) {
            this.buildConfiguration = aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation] inside the given [block]
         */
        public fun sourceBuildInformation(block: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation.Builder.() -> kotlin.Unit) {
            this.sourceBuildInformation = aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location] inside the given [block]
         */
        public fun sourceBundle(block: aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location.Builder.() -> kotlin.Unit) {
            this.sourceBundle = aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location.invoke(block)
        }
    }
}
