// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealthStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentLink
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateEnvironmentResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class UpdateEnvironmentOperationDeserializer: HttpDeserialize<UpdateEnvironmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateEnvironmentResponse {
        if (!response.status.isSuccess()) {
            throwUpdateEnvironmentError(context, response)
        }
        val builder = UpdateEnvironmentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateEnvironmentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateEnvironmentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyBucketsException" -> TooManyBucketsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateEnvironmentOperationBody(builder: UpdateEnvironmentResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("UpdateEnvironmentResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("UpdateEnvironmentResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap UpdateEnvironment response")
    }
    // end unwrap response wrapper

    val ABORTABLEOPERATIONINPROGRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("AbortableOperationInProgress"))
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ApplicationName"))
    val CNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CNAME"))
    val DATECREATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("DateCreated"))
    val DATEUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("DateUpdated"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Description"))
    val ENDPOINTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EndpointURL"))
    val ENVIRONMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EnvironmentArn"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EnvironmentId"))
    val ENVIRONMENTLINKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("EnvironmentLinks"))
    val ENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EnvironmentName"))
    val HEALTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Health"))
    val HEALTHSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("HealthStatus"))
    val OPERATIONSROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("OperationsRole"))
    val PLATFORMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PlatformArn"))
    val RESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Resources"))
    val SOLUTIONSTACKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SolutionStackName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val TEMPLATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TemplateName"))
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("Tier"))
    val VERSIONLABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("VersionLabel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticbeanstalk.amazonaws.com/docs/2010-12-01/"))
        trait(XmlSerialName("UpdateEnvironmentResult"))
        field(ABORTABLEOPERATIONINPROGRESS_DESCRIPTOR)
        field(APPLICATIONNAME_DESCRIPTOR)
        field(CNAME_DESCRIPTOR)
        field(DATECREATED_DESCRIPTOR)
        field(DATEUPDATED_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDPOINTURL_DESCRIPTOR)
        field(ENVIRONMENTARN_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(ENVIRONMENTLINKS_DESCRIPTOR)
        field(ENVIRONMENTNAME_DESCRIPTOR)
        field(HEALTH_DESCRIPTOR)
        field(HEALTHSTATUS_DESCRIPTOR)
        field(OPERATIONSROLE_DESCRIPTOR)
        field(PLATFORMARN_DESCRIPTOR)
        field(RESOURCES_DESCRIPTOR)
        field(SOLUTIONSTACKNAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TEMPLATENAME_DESCRIPTOR)
        field(TIER_DESCRIPTOR)
        field(VERSIONLABEL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ABORTABLEOPERATIONINPROGRESS_DESCRIPTOR.index -> builder.abortableOperationInProgress = deserializeBoolean()
                APPLICATIONNAME_DESCRIPTOR.index -> builder.applicationName = deserializeString()
                CNAME_DESCRIPTOR.index -> builder.cname = deserializeString()
                DATECREATED_DESCRIPTOR.index -> builder.dateCreated = deserializeString().let { Instant.fromIso8601(it) }
                DATEUPDATED_DESCRIPTOR.index -> builder.dateUpdated = deserializeString().let { Instant.fromIso8601(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDPOINTURL_DESCRIPTOR.index -> builder.endpointUrl = deserializeString()
                ENVIRONMENTARN_DESCRIPTOR.index -> builder.environmentArn = deserializeString()
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                ENVIRONMENTLINKS_DESCRIPTOR.index -> builder.environmentLinks =
                    deserializer.deserializeList(ENVIRONMENTLINKS_DESCRIPTOR) {
                        val col0 = mutableListOf<EnvironmentLink>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEnvironmentLinkDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENVIRONMENTNAME_DESCRIPTOR.index -> builder.environmentName = deserializeString()
                HEALTH_DESCRIPTOR.index -> builder.health = deserializeString().let { EnvironmentHealth.fromValue(it) }
                HEALTHSTATUS_DESCRIPTOR.index -> builder.healthStatus = deserializeString().let { EnvironmentHealthStatus.fromValue(it) }
                OPERATIONSROLE_DESCRIPTOR.index -> builder.operationsRole = deserializeString()
                PLATFORMARN_DESCRIPTOR.index -> builder.platformArn = deserializeString()
                RESOURCES_DESCRIPTOR.index -> builder.resources = deserializeEnvironmentResourcesDescriptionDocument(deserializer)
                SOLUTIONSTACKNAME_DESCRIPTOR.index -> builder.solutionStackName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EnvironmentStatus.fromValue(it) }
                TEMPLATENAME_DESCRIPTOR.index -> builder.templateName = deserializeString()
                TIER_DESCRIPTOR.index -> builder.tier = deserializeEnvironmentTierDocument(deserializer)
                VERSIONLABEL_DESCRIPTOR.index -> builder.versionLabel = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
