// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth
import aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeEnvironmentHealthOperationDeserializer: HttpDeserialize<DescribeEnvironmentHealthResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEnvironmentHealthResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEnvironmentHealthError(context, response)
        }
        val builder = DescribeEnvironmentHealthResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEnvironmentHealthOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEnvironmentHealthError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ElasticBeanstalkServiceException" -> ElasticBeanstalkServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEnvironmentHealthOperationBody(builder: DescribeEnvironmentHealthResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeEnvironmentHealthResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeEnvironmentHealthResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeEnvironmentHealth response")
    }
    // end unwrap response wrapper

    val APPLICATIONMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ApplicationMetrics"))
    val CAUSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Causes"))
    val COLOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Color"))
    val ENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EnvironmentName"))
    val HEALTHSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("HealthStatus"))
    val INSTANCESHEALTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("InstancesHealth"))
    val REFRESHEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("RefreshedAt"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticbeanstalk.amazonaws.com/docs/2010-12-01/"))
        trait(XmlSerialName("DescribeEnvironmentHealthResult"))
        field(APPLICATIONMETRICS_DESCRIPTOR)
        field(CAUSES_DESCRIPTOR)
        field(COLOR_DESCRIPTOR)
        field(ENVIRONMENTNAME_DESCRIPTOR)
        field(HEALTHSTATUS_DESCRIPTOR)
        field(INSTANCESHEALTH_DESCRIPTOR)
        field(REFRESHEDAT_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONMETRICS_DESCRIPTOR.index -> builder.applicationMetrics = deserializeApplicationMetricsDocument(deserializer)
                CAUSES_DESCRIPTOR.index -> builder.causes =
                    deserializer.deserializeList(CAUSES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                COLOR_DESCRIPTOR.index -> builder.color = deserializeString()
                ENVIRONMENTNAME_DESCRIPTOR.index -> builder.environmentName = deserializeString()
                HEALTHSTATUS_DESCRIPTOR.index -> builder.healthStatus = deserializeString()
                INSTANCESHEALTH_DESCRIPTOR.index -> builder.instancesHealth = deserializeInstanceHealthSummaryDocument(deserializer)
                REFRESHEDAT_DESCRIPTOR.index -> builder.refreshedAt = deserializeString().let { Instant.fromIso8601(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { EnvironmentHealth.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
