// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeConfigurationOptionsOperationDeserializer: HttpDeserialize<DescribeConfigurationOptionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeConfigurationOptionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeConfigurationOptionsError(context, response)
        }
        val builder = DescribeConfigurationOptionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeConfigurationOptionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeConfigurationOptionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyBucketsException" -> TooManyBucketsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeConfigurationOptionsOperationBody(builder: DescribeConfigurationOptionsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeConfigurationOptionsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeConfigurationOptionsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeConfigurationOptions response")
    }
    // end unwrap response wrapper

    val OPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Options"))
    val PLATFORMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("PlatformArn"))
    val SOLUTIONSTACKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SolutionStackName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticbeanstalk.amazonaws.com/docs/2010-12-01/"))
        trait(XmlSerialName("DescribeConfigurationOptionsResult"))
        field(OPTIONS_DESCRIPTOR)
        field(PLATFORMARN_DESCRIPTOR)
        field(SOLUTIONSTACKNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                OPTIONS_DESCRIPTOR.index -> builder.options =
                    deserializer.deserializeList(OPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ConfigurationOptionDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConfigurationOptionDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PLATFORMARN_DESCRIPTOR.index -> builder.platformArn = deserializeString()
                SOLUTIONSTACKNAME_DESCRIPTOR.index -> builder.solutionStackName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
