// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



public class ListPlatformBranchesRequest private constructor(builder: Builder) {
    /**
     * Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate `SearchFilter` terms.
     *
     * The following list shows valid attribute values for each of the `SearchFilter` terms. Most operators take a single value. The `in` and `not_in` operators can take multiple values.
     * + `Attribute = BranchName`:
     *    + `Operator`: `=` | `!=` | `begins_with` | `ends_with` | `contains` | `in` | `not_in`
     * + `Attribute = LifecycleState`:
     *    + `Operator`: `=` | `!=` | `in` | `not_in`
     *    + `Values`: `beta` | `supported` | `deprecated` | `retired`
     * + `Attribute = PlatformName`:
     *    + `Operator`: `=` | `!=` | `begins_with` | `ends_with` | `contains` | `in` | `not_in`
     * + `Attribute = TierType`:
     *    + `Operator`: `=` | `!=`
     *    + `Values`: `WebServer/Standard` | `Worker/SQS/HTTP`
     *
     * Array size: limited to 10 `SearchFilter` objects.
     *
     * Within each `SearchFilter` item, the `Values` array is limited to 10 items.
     */
    public val filters: List<SearchFilter>? = builder.filters
    /**
     * The maximum number of platform branch values returned in one call.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.
     *
     * If no `NextToken` is specified, the first page is retrieved.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformBranchesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPlatformBranchesRequest(")
        append("filters=$filters,")
        append("maxRecords=$maxRecords,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPlatformBranchesRequest

        if (filters != other.filters) return false
        if (maxRecords != other.maxRecords) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformBranchesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Criteria for restricting the resulting list of platform branches. The filter is evaluated as a logical conjunction (AND) of the separate `SearchFilter` terms.
         *
         * The following list shows valid attribute values for each of the `SearchFilter` terms. Most operators take a single value. The `in` and `not_in` operators can take multiple values.
         * + `Attribute = BranchName`:
         *    + `Operator`: `=` | `!=` | `begins_with` | `ends_with` | `contains` | `in` | `not_in`
         * + `Attribute = LifecycleState`:
         *    + `Operator`: `=` | `!=` | `in` | `not_in`
         *    + `Values`: `beta` | `supported` | `deprecated` | `retired`
         * + `Attribute = PlatformName`:
         *    + `Operator`: `=` | `!=` | `begins_with` | `ends_with` | `contains` | `in` | `not_in`
         * + `Attribute = TierType`:
         *    + `Operator`: `=` | `!=`
         *    + `Values`: `WebServer/Standard` | `Worker/SQS/HTTP`
         *
         * Array size: limited to 10 `SearchFilter` objects.
         *
         * Within each `SearchFilter` item, the `Values` array is limited to 10 items.
         */
        public var filters: List<SearchFilter>? = null
        /**
         * The maximum number of platform branch values returned in one call.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other parameter values must be identical to the ones specified in the initial request.
         *
         * If no `NextToken` is specified, the first page is retrieved.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformBranchesRequest) : this() {
            this.filters = x.filters
            this.maxRecords = x.maxRecords
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformBranchesRequest = ListPlatformBranchesRequest(this)
    }
}
