// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an application version deployment.
 */
public class Deployment private constructor(builder: Builder) {
    /**
     * The ID of the deployment. This number increases by one each time that you deploy source code or change instance configuration settings.
     */
    public val deploymentId: kotlin.Long? = builder.deploymentId
    /**
     * For in-progress deployments, the time that the deployment started.
     *
     * For completed deployments, the time that the deployment ended.
     */
    public val deploymentTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deploymentTime
    /**
     * The status of the deployment:
     * + `In Progress` : The deployment is in progress.
     * + `Deployed` : The deployment succeeded.
     * + `Failed` : The deployment failed.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The version label of the application version in the deployment.
     */
    public val versionLabel: kotlin.String? = builder.versionLabel

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Deployment(")
        append("deploymentId=$deploymentId,")
        append("deploymentTime=$deploymentTime,")
        append("status=$status,")
        append("versionLabel=$versionLabel")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (deploymentTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Deployment

        if (deploymentId != other.deploymentId) return false
        if (deploymentTime != other.deploymentTime) return false
        if (status != other.status) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the deployment. This number increases by one each time that you deploy source code or change instance configuration settings.
         */
        public var deploymentId: kotlin.Long? = null
        /**
         * For in-progress deployments, the time that the deployment started.
         *
         * For completed deployments, the time that the deployment ended.
         */
        public var deploymentTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the deployment:
         * + `In Progress` : The deployment is in progress.
         * + `Deployed` : The deployment succeeded.
         * + `Failed` : The deployment failed.
         */
        public var status: kotlin.String? = null
        /**
         * The version label of the application version in the deployment.
         */
        public var versionLabel: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment) : this() {
            this.deploymentId = x.deploymentId
            this.deploymentTime = x.deploymentTime
            this.status = x.status
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment = Deployment(this)
    }
}
