// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * A specification identifying an individual configuration option along with its current value. For a list of possible namespaces and option values, see [Option Values](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html) in the *AWS Elastic Beanstalk Developer Guide*.
 */
public class ConfigurationOptionSetting private constructor(builder: Builder) {
    /**
     * A unique namespace that identifies the option's associated AWS resource.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the configuration option.
     */
    public val optionName: kotlin.String? = builder.optionName
    /**
     * A unique resource name for the option setting. Use it for a time–based scaling configuration option.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The current value for the configuration option.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigurationOptionSetting(")
        append("namespace=$namespace,")
        append("optionName=$optionName,")
        append("resourceName=$resourceName,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespace?.hashCode() ?: 0
        result = 31 * result + (optionName?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigurationOptionSetting

        if (namespace != other.namespace) return false
        if (optionName != other.optionName) return false
        if (resourceName != other.resourceName) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique namespace that identifies the option's associated AWS resource.
         */
        public var namespace: kotlin.String? = null
        /**
         * The name of the configuration option.
         */
        public var optionName: kotlin.String? = null
        /**
         * A unique resource name for the option setting. Use it for a time–based scaling configuration option.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The current value for the configuration option.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionSetting) : this() {
            this.namespace = x.namespace
            this.optionName = x.optionName
            this.resourceName = x.resourceName
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionSetting = ConfigurationOptionSetting(this)
    }
}
