// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.waiters

import aws.sdk.kotlin.services.elasticbeanstalk.ElasticBeanstalkClient
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


suspend fun ElasticBeanstalkClient.waitUntilEnvironmentExists(request: DescribeEnvironmentsRequest): Outcome<DescribeEnvironmentsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 20_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeEnvironmentsRequest, DescribeEnvironmentsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val environments = it?.environments
            val environmentsOrEmpty = environments?.flattenIfPossible() ?: listOf()
            val projection = environmentsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "Ready" }
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val environments = it?.environments
            val environmentsOrEmpty = environments?.flattenIfPossible() ?: listOf()
            val projection = environmentsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "Launching" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEnvironments(request) }
}

suspend fun ElasticBeanstalkClient.waitUntilEnvironmentExists(block: DescribeEnvironmentsRequest.Builder.() -> Unit): Outcome<DescribeEnvironmentsResponse> =
    waitUntilEnvironmentExists(DescribeEnvironmentsRequest.Builder().apply(block).build())

suspend fun ElasticBeanstalkClient.waitUntilEnvironmentTerminated(request: DescribeEnvironmentsRequest): Outcome<DescribeEnvironmentsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 20_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeEnvironmentsRequest, DescribeEnvironmentsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val environments = it?.environments
            val environmentsOrEmpty = environments?.flattenIfPossible() ?: listOf()
            val projection = environmentsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "Terminated" }
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val environments = it?.environments
            val environmentsOrEmpty = environments?.flattenIfPossible() ?: listOf()
            val projection = environmentsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "Terminating" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEnvironments(request) }
}

suspend fun ElasticBeanstalkClient.waitUntilEnvironmentTerminated(block: DescribeEnvironmentsRequest.Builder.() -> Unit): Outcome<DescribeEnvironmentsResponse> =
    waitUntilEnvironmentTerminated(DescribeEnvironmentsRequest.Builder().apply(block).build())

suspend fun ElasticBeanstalkClient.waitUntilEnvironmentUpdated(request: DescribeEnvironmentsRequest): Outcome<DescribeEnvironmentsResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 20_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeEnvironmentsRequest, DescribeEnvironmentsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val environments = it?.environments
            val environmentsOrEmpty = environments?.flattenIfPossible() ?: listOf()
            val projection = environmentsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "Ready" }
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val environments = it?.environments
            val environmentsOrEmpty = environments?.flattenIfPossible() ?: listOf()
            val projection = environmentsOrEmpty.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "Updating" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeEnvironments(request) }
}

suspend fun ElasticBeanstalkClient.waitUntilEnvironmentUpdated(block: DescribeEnvironmentsRequest.Builder.() -> Unit): Outcome<DescribeEnvironmentsResponse> =
    waitUntilEnvironmentUpdated(DescribeEnvironmentsRequest.Builder().apply(block).build())
