// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * A list of validation messages for a specified configuration template.
 */
class ValidateConfigurationSettingsRequest private constructor(builder: Builder) {
    /**
     * The name of the application that the configuration template or environment belongs to.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * The name of the environment to validate the settings against.
     *
     * Condition: You cannot specify both this and a configuration template name.
     */
    val environmentName: kotlin.String? = builder.environmentName
    /**
     * A list of the options and desired values to evaluate.
     */
    val optionSettings: List<ConfigurationOptionSetting>? = builder.optionSettings
    /**
     * The name of the configuration template to validate the settings against.
     *
     * Condition: You cannot specify both this and an environment name.
     */
    val templateName: kotlin.String? = builder.templateName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ValidateConfigurationSettingsRequest(")
        append("applicationName=$applicationName,")
        append("environmentName=$environmentName,")
        append("optionSettings=$optionSettings,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (optionSettings?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ValidateConfigurationSettingsRequest

        if (applicationName != other.applicationName) return false
        if (environmentName != other.environmentName) return false
        if (optionSettings != other.optionSettings) return false
        if (templateName != other.templateName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the application that the configuration template or environment belongs to.
         */
        var applicationName: kotlin.String? = null
        /**
         * The name of the environment to validate the settings against.
         *
         * Condition: You cannot specify both this and a configuration template name.
         */
        var environmentName: kotlin.String? = null
        /**
         * A list of the options and desired values to evaluate.
         */
        var optionSettings: List<ConfigurationOptionSetting>? = null
        /**
         * The name of the configuration template to validate the settings against.
         *
         * Condition: You cannot specify both this and an environment name.
         */
        var templateName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest) : this() {
            this.applicationName = x.applicationName
            this.environmentName = x.environmentName
            this.optionSettings = x.optionSettings
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest = ValidateConfigurationSettingsRequest(this)
    }
}
