// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an application version deployment.
 */
class Deployment private constructor(builder: Builder) {
    /**
     * The ID of the deployment. This number increases by one each time that you deploy source code or change instance configuration settings.
     */
    val deploymentId: kotlin.Long? = builder.deploymentId
    /**
     * For in-progress deployments, the time that the deployment started.
     *
     * For completed deployments, the time that the deployment ended.
     */
    val deploymentTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deploymentTime
    /**
     * The status of the deployment:
     * + `In Progress` : The deployment is in progress.
     * + `Deployed` : The deployment succeeded.
     * + `Failed` : The deployment failed.
     */
    val status: kotlin.String? = builder.status
    /**
     * The version label of the application version in the deployment.
     */
    val versionLabel: kotlin.String? = builder.versionLabel

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Deployment(")
        append("deploymentId=$deploymentId,")
        append("deploymentTime=$deploymentTime,")
        append("status=$status,")
        append("versionLabel=$versionLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (deploymentTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Deployment

        if (deploymentId != other.deploymentId) return false
        if (deploymentTime != other.deploymentTime) return false
        if (status != other.status) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the deployment. This number increases by one each time that you deploy source code or change instance configuration settings.
         */
        var deploymentId: kotlin.Long? = null
        /**
         * For in-progress deployments, the time that the deployment started.
         *
         * For completed deployments, the time that the deployment ended.
         */
        var deploymentTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the deployment:
         * + `In Progress` : The deployment is in progress.
         * + `Deployed` : The deployment succeeded.
         * + `Failed` : The deployment failed.
         */
        var status: kotlin.String? = null
        /**
         * The version label of the application version in the deployment.
         */
        var versionLabel: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment) : this() {
            this.deploymentId = x.deploymentId
            this.deploymentTime = x.deploymentTime
            this.status = x.status
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment = Deployment(this)
    }
}
