// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the properties of an environment.
 */
class CreateEnvironmentResponse private constructor(builder: Builder) {
    /**
     * Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.
     *
     * `true:` There is an update in progress.
     *
     * `false:` There are no updates currently in progress.
     */
    val abortableOperationInProgress: kotlin.Boolean? = builder.abortableOperationInProgress
    /**
     * The name of the application associated with this environment.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * The URL to the CNAME for this environment.
     */
    val cname: kotlin.String? = builder.cname
    /**
     * The creation date for this environment.
     */
    val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The last modified date for this environment.
     */
    val dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateUpdated
    /**
     * Describes this environment.
     */
    val description: kotlin.String? = builder.description
    /**
     * For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.
     */
    val endpointUrl: kotlin.String? = builder.endpointUrl
    /**
     * The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.
     */
    val environmentArn: kotlin.String? = builder.environmentArn
    /**
     * The ID of this environment.
     */
    val environmentId: kotlin.String? = builder.environmentId
    /**
     * A list of links to other environments in the same group.
     */
    val environmentLinks: List<EnvironmentLink>? = builder.environmentLinks
    /**
     * The name of this environment.
     */
    val environmentName: kotlin.String? = builder.environmentName
    /**
     * Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:
     * + `Red`: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.
     * + `Yellow`: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.
     * + `Green`: Indicates the environment is healthy and fully functional.
     * + `Grey`: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an `UpdateEnvironment` or `RestartEnvironment` request.
     *
     *  Default: `Grey`
     */
    val health: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth? = builder.health
    /**
     * Returns the health status of the application running in your environment. For more information, see [Health Colors and Statuses](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
     */
    val healthStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealthStatus? = builder.healthStatus
    /**
     * The Amazon Resource Name (ARN) of the environment's operations role. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
     */
    val operationsRole: kotlin.String? = builder.operationsRole
    /**
     * The ARN of the platform version.
     */
    val platformArn: kotlin.String? = builder.platformArn
    /**
     * The description of the AWS resources used by this environment.
     */
    val resources: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription? = builder.resources
    /**
     * The name of the `SolutionStack` deployed with this environment.
     */
    val solutionStackName: kotlin.String? = builder.solutionStackName
    /**
     * The current operational status of the environment:
     * + `Launching`: Environment is in the process of initial deployment.
     * + `Updating`: Environment is in the process of updating its configuration settings or application version.
     * + `Ready`: Environment is available to have an action performed on it, such as update or terminate.
     * + `Terminating`: Environment is in the shut-down process.
     * + `Terminated`: Environment is not running.
     */
    val status: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentStatus? = builder.status
    /**
     * The name of the configuration template used to originally launch this environment.
     */
    val templateName: kotlin.String? = builder.templateName
    /**
     * Describes the current tier of this environment.
     */
    val tier: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier? = builder.tier
    /**
     * The application version deployed in this environment.
     */
    val versionLabel: kotlin.String? = builder.versionLabel

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentResponse(")
        append("abortableOperationInProgress=$abortableOperationInProgress,")
        append("applicationName=$applicationName,")
        append("cname=$cname,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("endpointUrl=$endpointUrl,")
        append("environmentArn=$environmentArn,")
        append("environmentId=$environmentId,")
        append("environmentLinks=$environmentLinks,")
        append("environmentName=$environmentName,")
        append("health=$health,")
        append("healthStatus=$healthStatus,")
        append("operationsRole=$operationsRole,")
        append("platformArn=$platformArn,")
        append("resources=$resources,")
        append("solutionStackName=$solutionStackName,")
        append("status=$status,")
        append("templateName=$templateName,")
        append("tier=$tier,")
        append("versionLabel=$versionLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortableOperationInProgress?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (cname?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpointUrl?.hashCode() ?: 0)
        result = 31 * result + (environmentArn?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (environmentLinks?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (operationsRole?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (solutionStackName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEnvironmentResponse

        if (abortableOperationInProgress != other.abortableOperationInProgress) return false
        if (applicationName != other.applicationName) return false
        if (cname != other.cname) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (endpointUrl != other.endpointUrl) return false
        if (environmentArn != other.environmentArn) return false
        if (environmentId != other.environmentId) return false
        if (environmentLinks != other.environmentLinks) return false
        if (environmentName != other.environmentName) return false
        if (health != other.health) return false
        if (healthStatus != other.healthStatus) return false
        if (operationsRole != other.operationsRole) return false
        if (platformArn != other.platformArn) return false
        if (resources != other.resources) return false
        if (solutionStackName != other.solutionStackName) return false
        if (status != other.status) return false
        if (templateName != other.templateName) return false
        if (tier != other.tier) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates if there is an in-progress environment configuration update or application version deployment that you can cancel.
         *
         * `true:` There is an update in progress.
         *
         * `false:` There are no updates currently in progress.
         */
        var abortableOperationInProgress: kotlin.Boolean? = null
        /**
         * The name of the application associated with this environment.
         */
        var applicationName: kotlin.String? = null
        /**
         * The URL to the CNAME for this environment.
         */
        var cname: kotlin.String? = null
        /**
         * The creation date for this environment.
         */
        var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last modified date for this environment.
         */
        var dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes this environment.
         */
        var description: kotlin.String? = null
        /**
         * For load-balanced, autoscaling environments, the URL to the LoadBalancer. For single-instance environments, the IP address of the instance.
         */
        var endpointUrl: kotlin.String? = null
        /**
         * The environment's Amazon Resource Name (ARN), which can be used in other API requests that require an ARN.
         */
        var environmentArn: kotlin.String? = null
        /**
         * The ID of this environment.
         */
        var environmentId: kotlin.String? = null
        /**
         * A list of links to other environments in the same group.
         */
        var environmentLinks: List<EnvironmentLink>? = null
        /**
         * The name of this environment.
         */
        var environmentName: kotlin.String? = null
        /**
         * Describes the health status of the environment. AWS Elastic Beanstalk indicates the failure levels for a running environment:
         * + `Red`: Indicates the environment is not responsive. Occurs when three or more consecutive failures occur for an environment.
         * + `Yellow`: Indicates that something is wrong. Occurs when two consecutive failures occur for an environment.
         * + `Green`: Indicates the environment is healthy and fully functional.
         * + `Grey`: Default health for a new environment. The environment is not fully launched and health checks have not started or health checks are suspended during an `UpdateEnvironment` or `RestartEnvironment` request.
         *
         *  Default: `Grey`
         */
        var health: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth? = null
        /**
         * Returns the health status of the application running in your environment. For more information, see [Health Colors and Statuses](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
         */
        var healthStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealthStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the environment's operations role. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
         */
        var operationsRole: kotlin.String? = null
        /**
         * The ARN of the platform version.
         */
        var platformArn: kotlin.String? = null
        /**
         * The description of the AWS resources used by this environment.
         */
        var resources: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription? = null
        /**
         * The name of the `SolutionStack` deployed with this environment.
         */
        var solutionStackName: kotlin.String? = null
        /**
         * The current operational status of the environment:
         * + `Launching`: Environment is in the process of initial deployment.
         * + `Updating`: Environment is in the process of updating its configuration settings or application version.
         * + `Ready`: Environment is available to have an action performed on it, such as update or terminate.
         * + `Terminating`: Environment is in the shut-down process.
         * + `Terminated`: Environment is not running.
         */
        var status: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentStatus? = null
        /**
         * The name of the configuration template used to originally launch this environment.
         */
        var templateName: kotlin.String? = null
        /**
         * Describes the current tier of this environment.
         */
        var tier: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier? = null
        /**
         * The application version deployed in this environment.
         */
        var versionLabel: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentResponse) : this() {
            this.abortableOperationInProgress = x.abortableOperationInProgress
            this.applicationName = x.applicationName
            this.cname = x.cname
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.endpointUrl = x.endpointUrl
            this.environmentArn = x.environmentArn
            this.environmentId = x.environmentId
            this.environmentLinks = x.environmentLinks
            this.environmentName = x.environmentName
            this.health = x.health
            this.healthStatus = x.healthStatus
            this.operationsRole = x.operationsRole
            this.platformArn = x.platformArn
            this.resources = x.resources
            this.solutionStackName = x.solutionStackName
            this.status = x.status
            this.templateName = x.templateName
            this.tier = x.tier
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentResponse = CreateEnvironmentResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription] inside the given [block]
         */
        fun resources(block: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier] inside the given [block]
         */
        fun tier(block: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier.Builder.() -> kotlin.Unit) {
            this.tier = aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier.invoke(block)
        }
    }
}
