// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Request to create a configuration template.
 */
class CreateConfigurationTemplateRequest private constructor(builder: Builder) {
    /**
     * The name of the Elastic Beanstalk application to associate with this configuration template.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * An optional description for this configuration.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ID of an environment whose settings you want to use to create the configuration template. You must specify `EnvironmentId` if you don't specify `PlatformArn`, `SolutionStackName`, or `SourceConfiguration`.
     */
    val environmentId: kotlin.String? = builder.environmentId
    /**
     * Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see [Option Values](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html) in the *AWS Elastic Beanstalk Developer Guide*.
     */
    val optionSettings: List<ConfigurationOptionSetting>? = builder.optionSettings
    /**
     * The Amazon Resource Name (ARN) of the custom platform. For more information, see [ Custom Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html) in the *AWS Elastic Beanstalk Developer Guide*.
     *
     * If you specify `PlatformArn`, then don't specify `SolutionStackName`.
     */
    val platformArn: kotlin.String? = builder.platformArn
    /**
     * The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, `64bit Amazon Linux 2013.09 running Tomcat 7 Java 7`. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see [Supported Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html) in the *AWS Elastic Beanstalk Developer Guide*.
     *
     * You must specify `SolutionStackName` if you don't specify `PlatformArn`, `EnvironmentId`, or `SourceConfiguration`.
     *
     * Use the `ListAvailableSolutionStacks`[](https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html) API to obtain a list of available solution stacks.
     */
    val solutionStackName: kotlin.String? = builder.solutionStackName
    /**
     * An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.
     *
     * Values specified in `OptionSettings` override any values obtained from the `SourceConfiguration`.
     *
     * You must specify `SourceConfiguration` if you don't specify `PlatformArn`, `EnvironmentId`, or `SolutionStackName`.
     *
     * Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.
     */
    val sourceConfiguration: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceConfiguration? = builder.sourceConfiguration
    /**
     * Specifies the tags applied to the configuration template.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The name of the configuration template.
     *
     * Constraint: This name must be unique per application.
     */
    val templateName: kotlin.String? = builder.templateName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConfigurationTemplateRequest(")
        append("applicationName=$applicationName,")
        append("description=$description,")
        append("environmentId=$environmentId,")
        append("optionSettings=$optionSettings,")
        append("platformArn=$platformArn,")
        append("solutionStackName=$solutionStackName,")
        append("sourceConfiguration=$sourceConfiguration,")
        append("tags=$tags,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (optionSettings?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (solutionStackName?.hashCode() ?: 0)
        result = 31 * result + (sourceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConfigurationTemplateRequest

        if (applicationName != other.applicationName) return false
        if (description != other.description) return false
        if (environmentId != other.environmentId) return false
        if (optionSettings != other.optionSettings) return false
        if (platformArn != other.platformArn) return false
        if (solutionStackName != other.solutionStackName) return false
        if (sourceConfiguration != other.sourceConfiguration) return false
        if (tags != other.tags) return false
        if (templateName != other.templateName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Elastic Beanstalk application to associate with this configuration template.
         */
        var applicationName: kotlin.String? = null
        /**
         * An optional description for this configuration.
         */
        var description: kotlin.String? = null
        /**
         * The ID of an environment whose settings you want to use to create the configuration template. You must specify `EnvironmentId` if you don't specify `PlatformArn`, `SolutionStackName`, or `SourceConfiguration`.
         */
        var environmentId: kotlin.String? = null
        /**
         * Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see [Option Values](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html) in the *AWS Elastic Beanstalk Developer Guide*.
         */
        var optionSettings: List<ConfigurationOptionSetting>? = null
        /**
         * The Amazon Resource Name (ARN) of the custom platform. For more information, see [ Custom Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html) in the *AWS Elastic Beanstalk Developer Guide*.
         *
         * If you specify `PlatformArn`, then don't specify `SolutionStackName`.
         */
        var platformArn: kotlin.String? = null
        /**
         * The name of an Elastic Beanstalk solution stack (platform version) that this configuration uses. For example, `64bit Amazon Linux 2013.09 running Tomcat 7 Java 7`. A solution stack specifies the operating system, runtime, and application server for a configuration template. It also determines the set of configuration options as well as the possible and default values. For more information, see [Supported Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html) in the *AWS Elastic Beanstalk Developer Guide*.
         *
         * You must specify `SolutionStackName` if you don't specify `PlatformArn`, `EnvironmentId`, or `SourceConfiguration`.
         *
         * Use the `ListAvailableSolutionStacks`[](https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html) API to obtain a list of available solution stacks.
         */
        var solutionStackName: kotlin.String? = null
        /**
         * An Elastic Beanstalk configuration template to base this one on. If specified, Elastic Beanstalk uses the configuration values from the specified configuration template to create a new configuration.
         *
         * Values specified in `OptionSettings` override any values obtained from the `SourceConfiguration`.
         *
         * You must specify `SourceConfiguration` if you don't specify `PlatformArn`, `EnvironmentId`, or `SolutionStackName`.
         *
         * Constraint: If both solution stack name and source configuration are specified, the solution stack of the source configuration template must match the specified solution stack name.
         */
        var sourceConfiguration: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceConfiguration? = null
        /**
         * Specifies the tags applied to the configuration template.
         */
        var tags: List<Tag>? = null
        /**
         * The name of the configuration template.
         *
         * Constraint: This name must be unique per application.
         */
        var templateName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest) : this() {
            this.applicationName = x.applicationName
            this.description = x.description
            this.environmentId = x.environmentId
            this.optionSettings = x.optionSettings
            this.platformArn = x.platformArn
            this.solutionStackName = x.solutionStackName
            this.sourceConfiguration = x.sourceConfiguration
            this.tags = x.tags
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest = CreateConfigurationTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.SourceConfiguration] inside the given [block]
         */
        fun sourceConfiguration(block: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceConfiguration.Builder.() -> kotlin.Unit) {
            this.sourceConfiguration = aws.sdk.kotlin.services.elasticbeanstalk.model.SourceConfiguration.invoke(block)
        }
    }
}
