// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.elasticbeanstalk.model.*
import aws.sdk.kotlin.services.elasticbeanstalk.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Elastic Beanstalk"
const val ServiceApiVersion: String = "2010-12-01"
const val SdkVersion: String = "0.16.7-beta"

internal class DefaultElasticBeanstalkClient(override val config: ElasticBeanstalkClient.Config) : ElasticBeanstalkClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Cancels in-progress environment configuration update or application version deployment.
     */
    override suspend fun abortEnvironmentUpdate(input: AbortEnvironmentUpdateRequest): AbortEnvironmentUpdateResponse {
        val op = SdkHttpOperation.build<AbortEnvironmentUpdateRequest, AbortEnvironmentUpdateResponse> {
            serializer = AbortEnvironmentUpdateOperationSerializer()
            deserializer = AbortEnvironmentUpdateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AbortEnvironmentUpdate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies a scheduled managed action immediately. A managed action can be applied only if its status is `Scheduled`. Get the status and action ID of a managed action with DescribeEnvironmentManagedActions.
     */
    override suspend fun applyEnvironmentManagedAction(input: ApplyEnvironmentManagedActionRequest): ApplyEnvironmentManagedActionResponse {
        val op = SdkHttpOperation.build<ApplyEnvironmentManagedActionRequest, ApplyEnvironmentManagedActionResponse> {
            serializer = ApplyEnvironmentManagedActionOperationSerializer()
            deserializer = ApplyEnvironmentManagedActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ApplyEnvironmentManagedAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the associated operations role for permissions to downstream services during subsequent calls acting on this environment. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
     */
    override suspend fun associateEnvironmentOperationsRole(input: AssociateEnvironmentOperationsRoleRequest): AssociateEnvironmentOperationsRoleResponse {
        val op = SdkHttpOperation.build<AssociateEnvironmentOperationsRoleRequest, AssociateEnvironmentOperationsRoleResponse> {
            serializer = AssociateEnvironmentOperationsRoleOperationSerializer()
            deserializer = AssociateEnvironmentOperationsRoleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateEnvironmentOperationsRole"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Checks if the specified CNAME is available.
     */
    override suspend fun checkDnsAvailability(input: CheckDnsAvailabilityRequest): CheckDnsAvailabilityResponse {
        val op = SdkHttpOperation.build<CheckDnsAvailabilityRequest, CheckDnsAvailabilityResponse> {
            serializer = CheckDNSAvailabilityOperationSerializer()
            deserializer = CheckDNSAvailabilityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CheckDNSAvailability"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create or update a group of environments that each run a separate component of a single application. Takes a list of version labels that specify application source bundles for each of the environments to create or update. The name of each environment and other required information must be included in the source bundles in an environment manifest named `env.yaml`. See [Compose Environments](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html) for details.
     */
    override suspend fun composeEnvironments(input: ComposeEnvironmentsRequest): ComposeEnvironmentsResponse {
        val op = SdkHttpOperation.build<ComposeEnvironmentsRequest, ComposeEnvironmentsResponse> {
            serializer = ComposeEnvironmentsOperationSerializer()
            deserializer = ComposeEnvironmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ComposeEnvironments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an application that has one configuration template named `default` and no application versions.
     */
    override suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse {
        val op = SdkHttpOperation.build<CreateApplicationRequest, CreateApplicationResponse> {
            serializer = CreateApplicationOperationSerializer()
            deserializer = CreateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an application version for the specified application. You can create an application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
     *
     * Specify a commit in an AWS CodeCommit repository with `SourceBuildInformation`.
     *
     * Specify a build in an AWS CodeBuild with `SourceBuildInformation` and `BuildConfiguration`.
     *
     * Specify a source bundle in S3 with `SourceBundle`
     *
     * Omit both `SourceBuildInformation` and `SourceBundle` to use the default sample application.
     *
     * After you create an application version with a specified Amazon S3 bucket and key location, you can't change that Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an environment from the application version.
     */
    override suspend fun createApplicationVersion(input: CreateApplicationVersionRequest): CreateApplicationVersionResponse {
        val op = SdkHttpOperation.build<CreateApplicationVersionRequest, CreateApplicationVersionResponse> {
            serializer = CreateApplicationVersionOperationSerializer()
            deserializer = CreateApplicationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApplicationVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk application. You define application configuration settings in a configuration template. You can then use the configuration template to deploy different versions of the application with the same configuration settings.
     *
     * Templates aren't associated with any environment. The `EnvironmentName` response element is always `null`.
     *
     * Related Topics
     * + DescribeConfigurationOptions
     * + DescribeConfigurationSettings
     * + ListAvailableSolutionStacks
     */
    override suspend fun createConfigurationTemplate(input: CreateConfigurationTemplateRequest): CreateConfigurationTemplateResponse {
        val op = SdkHttpOperation.build<CreateConfigurationTemplateRequest, CreateConfigurationTemplateResponse> {
            serializer = CreateConfigurationTemplateOperationSerializer()
            deserializer = CreateConfigurationTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConfigurationTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
     */
    override suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse {
        val op = SdkHttpOperation.build<CreateEnvironmentRequest, CreateEnvironmentResponse> {
            serializer = CreateEnvironmentOperationSerializer()
            deserializer = CreateEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Create a new version of your custom platform.
     */
    override suspend fun createPlatformVersion(input: CreatePlatformVersionRequest): CreatePlatformVersionResponse {
        val op = SdkHttpOperation.build<CreatePlatformVersionRequest, CreatePlatformVersionResponse> {
            serializer = CreatePlatformVersionOperationSerializer()
            deserializer = CreatePlatformVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePlatformVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in a region. If the storage location already exists, `CreateStorageLocation` still returns the bucket name but does not create a new bucket.
     */
    override suspend fun createStorageLocation(input: CreateStorageLocationRequest): CreateStorageLocationResponse {
        val op = SdkHttpOperation.build<CreateStorageLocationRequest, CreateStorageLocationResponse> {
            serializer = CreateStorageLocationOperationSerializer()
            deserializer = CreateStorageLocationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStorageLocation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified application along with all associated versions and configurations. The application versions will not be deleted from your Amazon S3 bucket.
     *
     * You cannot delete an application that has a running environment.
     */
    override suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse {
        val op = SdkHttpOperation.build<DeleteApplicationRequest, DeleteApplicationResponse> {
            serializer = DeleteApplicationOperationSerializer()
            deserializer = DeleteApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified version from the specified application.
     *
     * You cannot delete an application version that is associated with a running environment.
     */
    override suspend fun deleteApplicationVersion(input: DeleteApplicationVersionRequest): DeleteApplicationVersionResponse {
        val op = SdkHttpOperation.build<DeleteApplicationVersionRequest, DeleteApplicationVersionResponse> {
            serializer = DeleteApplicationVersionOperationSerializer()
            deserializer = DeleteApplicationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApplicationVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified configuration template.
     *
     * When you launch an environment using a configuration template, the environment gets a copy of the template. You can delete or modify the environment's copy of the template without affecting the running environment.
     */
    override suspend fun deleteConfigurationTemplate(input: DeleteConfigurationTemplateRequest): DeleteConfigurationTemplateResponse {
        val op = SdkHttpOperation.build<DeleteConfigurationTemplateRequest, DeleteConfigurationTemplateResponse> {
            serializer = DeleteConfigurationTemplateOperationSerializer()
            deserializer = DeleteConfigurationTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConfigurationTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the draft configuration associated with the running environment.
     *
     * Updating a running environment with any configuration changes creates a draft configuration set. You can get the draft configuration using DescribeConfigurationSettings while the update is in progress or if the update fails. The `DeploymentStatus` for the draft configuration indicates whether the deployment is in process or has failed. The draft configuration remains in existence until it is deleted with this action.
     */
    override suspend fun deleteEnvironmentConfiguration(input: DeleteEnvironmentConfigurationRequest): DeleteEnvironmentConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteEnvironmentConfigurationRequest, DeleteEnvironmentConfigurationResponse> {
            serializer = DeleteEnvironmentConfigurationOperationSerializer()
            deserializer = DeleteEnvironmentConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEnvironmentConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified version of a custom platform.
     */
    override suspend fun deletePlatformVersion(input: DeletePlatformVersionRequest): DeletePlatformVersionResponse {
        val op = SdkHttpOperation.build<DeletePlatformVersionRequest, DeletePlatformVersionResponse> {
            serializer = DeletePlatformVersionOperationSerializer()
            deserializer = DeletePlatformVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePlatformVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     *
     * The result currently has one set of attributes—resource quotas.
     */
    override suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse> {
            serializer = DescribeAccountAttributesOperationSerializer()
            deserializer = DescribeAccountAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieve a list of application versions.
     */
    override suspend fun describeApplicationVersions(input: DescribeApplicationVersionsRequest): DescribeApplicationVersionsResponse {
        val op = SdkHttpOperation.build<DescribeApplicationVersionsRequest, DescribeApplicationVersionsResponse> {
            serializer = DescribeApplicationVersionsOperationSerializer()
            deserializer = DescribeApplicationVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplicationVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the descriptions of existing applications.
     */
    override suspend fun describeApplications(input: DescribeApplicationsRequest): DescribeApplicationsResponse {
        val op = SdkHttpOperation.build<DescribeApplicationsRequest, DescribeApplicationsResponse> {
            serializer = DescribeApplicationsOperationSerializer()
            deserializer = DescribeApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeApplications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the configuration options that are used in a particular configuration template or environment, or that a specified solution stack defines. The description includes the values the options, their default values, and an indication of the required action on a running environment if an option value is changed.
     */
    override suspend fun describeConfigurationOptions(input: DescribeConfigurationOptionsRequest): DescribeConfigurationOptionsResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationOptionsRequest, DescribeConfigurationOptionsResponse> {
            serializer = DescribeConfigurationOptionsOperationSerializer()
            deserializer = DescribeConfigurationOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConfigurationOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a description of the settings for the specified configuration set, that is, either a configuration template or the configuration set associated with a running environment.
     *
     * When describing the settings for the configuration set associated with a running environment, it is possible to receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft configuration of an environment that is either in the process of deployment or that failed to deploy.
     *
     * Related Topics
     * + DeleteEnvironmentConfiguration
     */
    override suspend fun describeConfigurationSettings(input: DescribeConfigurationSettingsRequest): DescribeConfigurationSettingsResponse {
        val op = SdkHttpOperation.build<DescribeConfigurationSettingsRequest, DescribeConfigurationSettingsResponse> {
            serializer = DescribeConfigurationSettingsOperationSerializer()
            deserializer = DescribeConfigurationSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConfigurationSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the overall health of the specified environment. The **DescribeEnvironmentHealth** operation is only available with AWS Elastic Beanstalk Enhanced Health.
     */
    override suspend fun describeEnvironmentHealth(input: DescribeEnvironmentHealthRequest): DescribeEnvironmentHealthResponse {
        val op = SdkHttpOperation.build<DescribeEnvironmentHealthRequest, DescribeEnvironmentHealthResponse> {
            serializer = DescribeEnvironmentHealthOperationSerializer()
            deserializer = DescribeEnvironmentHealthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEnvironmentHealth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists an environment's completed and failed managed actions.
     */
    override suspend fun describeEnvironmentManagedActionHistory(input: DescribeEnvironmentManagedActionHistoryRequest): DescribeEnvironmentManagedActionHistoryResponse {
        val op = SdkHttpOperation.build<DescribeEnvironmentManagedActionHistoryRequest, DescribeEnvironmentManagedActionHistoryResponse> {
            serializer = DescribeEnvironmentManagedActionHistoryOperationSerializer()
            deserializer = DescribeEnvironmentManagedActionHistoryOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEnvironmentManagedActionHistory"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists an environment's upcoming and in-progress managed actions.
     */
    override suspend fun describeEnvironmentManagedActions(input: DescribeEnvironmentManagedActionsRequest): DescribeEnvironmentManagedActionsResponse {
        val op = SdkHttpOperation.build<DescribeEnvironmentManagedActionsRequest, DescribeEnvironmentManagedActionsResponse> {
            serializer = DescribeEnvironmentManagedActionsOperationSerializer()
            deserializer = DescribeEnvironmentManagedActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEnvironmentManagedActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns AWS resources for this environment.
     */
    override suspend fun describeEnvironmentResources(input: DescribeEnvironmentResourcesRequest): DescribeEnvironmentResourcesResponse {
        val op = SdkHttpOperation.build<DescribeEnvironmentResourcesRequest, DescribeEnvironmentResourcesResponse> {
            serializer = DescribeEnvironmentResourcesOperationSerializer()
            deserializer = DescribeEnvironmentResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEnvironmentResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns descriptions for existing environments.
     */
    override suspend fun describeEnvironments(input: DescribeEnvironmentsRequest): DescribeEnvironmentsResponse {
        val op = SdkHttpOperation.build<DescribeEnvironmentsRequest, DescribeEnvironmentsResponse> {
            serializer = DescribeEnvironmentsOperationSerializer()
            deserializer = DescribeEnvironmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEnvironments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     *
     * This action returns the most recent 1,000 events from the specified `NextToken`.
     */
    override suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse {
        val op = SdkHttpOperation.build<DescribeEventsRequest, DescribeEventsResponse> {
            serializer = DescribeEventsOperationSerializer()
            deserializer = DescribeEventsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEvents"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation requires [enhanced health reporting](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html).
     */
    override suspend fun describeInstancesHealth(input: DescribeInstancesHealthRequest): DescribeInstancesHealthResponse {
        val op = SdkHttpOperation.build<DescribeInstancesHealthRequest, DescribeInstancesHealthResponse> {
            serializer = DescribeInstancesHealthOperationSerializer()
            deserializer = DescribeInstancesHealthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstancesHealth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a platform version. Provides full details. Compare to ListPlatformVersions, which provides summary information about a list of platform versions.
     *
     * For definitions of platform version and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
     */
    override suspend fun describePlatformVersion(input: DescribePlatformVersionRequest): DescribePlatformVersionResponse {
        val op = SdkHttpOperation.build<DescribePlatformVersionRequest, DescribePlatformVersionResponse> {
            serializer = DescribePlatformVersionOperationSerializer()
            deserializer = DescribePlatformVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePlatformVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the caller's permissions for permissions to downstream services during subsequent calls acting on this environment. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
     */
    override suspend fun disassociateEnvironmentOperationsRole(input: DisassociateEnvironmentOperationsRoleRequest): DisassociateEnvironmentOperationsRoleResponse {
        val op = SdkHttpOperation.build<DisassociateEnvironmentOperationsRoleRequest, DisassociateEnvironmentOperationsRoleResponse> {
            serializer = DisassociateEnvironmentOperationsRoleOperationSerializer()
            deserializer = DisassociateEnvironmentOperationsRoleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateEnvironmentOperationsRole"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the available solution stack names, with the public version first and then in reverse chronological order.
     */
    override suspend fun listAvailableSolutionStacks(input: ListAvailableSolutionStacksRequest): ListAvailableSolutionStacksResponse {
        val op = SdkHttpOperation.build<ListAvailableSolutionStacksRequest, ListAvailableSolutionStacksResponse> {
            serializer = ListAvailableSolutionStacksOperationSerializer()
            deserializer = ListAvailableSolutionStacksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAvailableSolutionStacks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each platform branch.
     *
     * For definitions of platform branch and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
     */
    override suspend fun listPlatformBranches(input: ListPlatformBranchesRequest): ListPlatformBranchesResponse {
        val op = SdkHttpOperation.build<ListPlatformBranchesRequest, ListPlatformBranchesResponse> {
            serializer = ListPlatformBranchesOperationSerializer()
            deserializer = ListPlatformBranchesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPlatformBranches"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each platform version. Compare to DescribePlatformVersion, which provides full details about a single platform version.
     *
     * For definitions of platform version and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
     */
    override suspend fun listPlatformVersions(input: ListPlatformVersionsRequest): ListPlatformVersionsResponse {
        val op = SdkHttpOperation.build<ListPlatformVersionsRequest, ListPlatformVersionsResponse> {
            serializer = ListPlatformVersionsOperationSerializer()
            deserializer = ListPlatformVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPlatformVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value pairs.
     *
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see [Tagging Application Resources](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a specified environment and forces a restart.
     */
    override suspend fun rebuildEnvironment(input: RebuildEnvironmentRequest): RebuildEnvironmentResponse {
        val op = SdkHttpOperation.build<RebuildEnvironmentRequest, RebuildEnvironmentResponse> {
            serializer = RebuildEnvironmentOperationSerializer()
            deserializer = RebuildEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RebuildEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Initiates a request to compile the specified type of information of the deployed environment.
     *
     *  Setting the `InfoType` to `tail` compiles the last lines from the application server log files of every Amazon EC2 instance in your environment.
     *
     *  Setting the `InfoType` to `bundle` compresses the application server log files for every Amazon EC2 instance into a `.zip` file. Legacy and .NET containers do not support bundle logs.
     *
     *  Use RetrieveEnvironmentInfo to obtain the set of logs.
     *
     * Related Topics
     * + RetrieveEnvironmentInfo
     */
    override suspend fun requestEnvironmentInfo(input: RequestEnvironmentInfoRequest): RequestEnvironmentInfoResponse {
        val op = SdkHttpOperation.build<RequestEnvironmentInfoRequest, RequestEnvironmentInfoResponse> {
            serializer = RequestEnvironmentInfoOperationSerializer()
            deserializer = RequestEnvironmentInfoOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RequestEnvironmentInfo"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Causes the environment to restart the application container server running on each Amazon EC2 instance.
     */
    override suspend fun restartAppServer(input: RestartAppServerRequest): RestartAppServerResponse {
        val op = SdkHttpOperation.build<RestartAppServerRequest, RestartAppServerResponse> {
            serializer = RestartAppServerOperationSerializer()
            deserializer = RestartAppServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestartAppServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the compiled information from a RequestEnvironmentInfo request.
     *
     * Related Topics
     * + RequestEnvironmentInfo
     */
    override suspend fun retrieveEnvironmentInfo(input: RetrieveEnvironmentInfoRequest): RetrieveEnvironmentInfoResponse {
        val op = SdkHttpOperation.build<RetrieveEnvironmentInfoRequest, RetrieveEnvironmentInfoResponse> {
            serializer = RetrieveEnvironmentInfoOperationSerializer()
            deserializer = RetrieveEnvironmentInfoOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RetrieveEnvironmentInfo"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Swaps the CNAMEs of two environments.
     */
    override suspend fun swapEnvironmentCnamEs(input: SwapEnvironmentCnamEsRequest): SwapEnvironmentCnamEsResponse {
        val op = SdkHttpOperation.build<SwapEnvironmentCnamEsRequest, SwapEnvironmentCnamEsResponse> {
            serializer = SwapEnvironmentCNAMEsOperationSerializer()
            deserializer = SwapEnvironmentCNAMEsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SwapEnvironmentCNAMEs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Terminates the specified environment.
     */
    override suspend fun terminateEnvironment(input: TerminateEnvironmentRequest): TerminateEnvironmentResponse {
        val op = SdkHttpOperation.build<TerminateEnvironmentRequest, TerminateEnvironmentResponse> {
            serializer = TerminateEnvironmentOperationSerializer()
            deserializer = TerminateEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TerminateEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified application to have the specified properties.
     *
     * If a property (for example, `description`) is not provided, the value remains unchanged. To clear these properties, specify an empty string.
     */
    override suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse {
        val op = SdkHttpOperation.build<UpdateApplicationRequest, UpdateApplicationResponse> {
            serializer = UpdateApplicationOperationSerializer()
            deserializer = UpdateApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplication"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies lifecycle settings for an application.
     */
    override suspend fun updateApplicationResourceLifecycle(input: UpdateApplicationResourceLifecycleRequest): UpdateApplicationResourceLifecycleResponse {
        val op = SdkHttpOperation.build<UpdateApplicationResourceLifecycleRequest, UpdateApplicationResourceLifecycleResponse> {
            serializer = UpdateApplicationResourceLifecycleOperationSerializer()
            deserializer = UpdateApplicationResourceLifecycleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplicationResourceLifecycle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified application version to have the specified properties.
     *
     * If a property (for example, `description`) is not provided, the value remains unchanged. To clear properties, specify an empty string.
     */
    override suspend fun updateApplicationVersion(input: UpdateApplicationVersionRequest): UpdateApplicationVersionResponse {
        val op = SdkHttpOperation.build<UpdateApplicationVersionRequest, UpdateApplicationVersionResponse> {
            serializer = UpdateApplicationVersionOperationSerializer()
            deserializer = UpdateApplicationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApplicationVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified configuration template to have the specified properties or configuration option values.
     *
     * If a property (for example, `ApplicationName`) is not provided, its value remains unchanged. To clear such properties, specify an empty string.
     *
     * Related Topics
     * + DescribeConfigurationOptions
     */
    override suspend fun updateConfigurationTemplate(input: UpdateConfigurationTemplateRequest): UpdateConfigurationTemplateResponse {
        val op = SdkHttpOperation.build<UpdateConfigurationTemplateRequest, UpdateConfigurationTemplateResponse> {
            serializer = UpdateConfigurationTemplateOperationSerializer()
            deserializer = UpdateConfigurationTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConfigurationTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the environment description, deploys a new application version, updates the configuration settings to an entirely new configuration template, or updates select configuration option values in the running environment.
     *
     *  Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an `InvalidParameterCombination` error.
     *
     *  When updating the configuration settings to a new template or individual settings, a draft configuration is created and DescribeConfigurationSettings for this environment returns two setting descriptions with different `DeploymentStatus` values.
     */
    override suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse {
        val op = SdkHttpOperation.build<UpdateEnvironmentRequest, UpdateEnvironmentResponse> {
            serializer = UpdateEnvironmentOperationSerializer()
            deserializer = UpdateEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed: `TagsToAdd` for tags to add or update, and `TagsToRemove`.
     *
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see [Tagging Application Resources](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
     *
     * If you create a custom IAM user policy to control permission to this operation, specify one of the following two virtual actions (or both) instead of the API operation name:
     *
     * ## elasticbeanstalk:AddTags
     * Controls permission to call `UpdateTagsForResource` and pass a list of tags to add in the `TagsToAdd` parameter.
     *
     * ## elasticbeanstalk:RemoveTags
     * Controls permission to call `UpdateTagsForResource` and pass a list of tag keys to remove in the `TagsToRemove` parameter.
     *
     * For details about creating a custom user policy, see [Creating a Custom User Policy](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies).
     */
    override suspend fun updateTagsForResource(input: UpdateTagsForResourceRequest): UpdateTagsForResourceResponse {
        val op = SdkHttpOperation.build<UpdateTagsForResourceRequest, UpdateTagsForResourceResponse> {
            serializer = UpdateTagsForResourceOperationSerializer()
            deserializer = UpdateTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Takes a set of configuration settings and either a configuration template or environment, and determines whether those values are valid.
     *
     * This action returns a list of messages indicating any errors or warnings associated with the selection of option values.
     */
    override suspend fun validateConfigurationSettings(input: ValidateConfigurationSettingsRequest): ValidateConfigurationSettingsResponse {
        val op = SdkHttpOperation.build<ValidateConfigurationSettingsRequest, ValidateConfigurationSettingsResponse> {
            serializer = ValidateConfigurationSettingsOperationSerializer()
            deserializer = ValidateConfigurationSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ValidateConfigurationSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elasticbeanstalk"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "elasticbeanstalk")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
