// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.SolutionStackDescription
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ListAvailableSolutionStacksOperationDeserializer: HttpDeserialize<ListAvailableSolutionStacksResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAvailableSolutionStacksResponse {
        if (!response.status.isSuccess()) {
            throwListAvailableSolutionStacksError(context, response)
        }
        val builder = ListAvailableSolutionStacksResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAvailableSolutionStacksOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListAvailableSolutionStacksError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAvailableSolutionStacksOperationBody(builder: ListAvailableSolutionStacksResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ListAvailableSolutionStacksResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListAvailableSolutionStacksResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ListAvailableSolutionStacks response")
    }
    // end unwrap response wrapper

    val SOLUTIONSTACKDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("SolutionStackDetails"))
    val SOLUTIONSTACKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("SolutionStacks"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticbeanstalk.amazonaws.com/docs/2010-12-01/"))
        trait(XmlSerialName("ListAvailableSolutionStacksResult"))
        field(SOLUTIONSTACKDETAILS_DESCRIPTOR)
        field(SOLUTIONSTACKS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SOLUTIONSTACKDETAILS_DESCRIPTOR.index -> builder.solutionStackDetails =
                    deserializer.deserializeList(SOLUTIONSTACKDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<SolutionStackDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSolutionStackDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SOLUTIONSTACKS_DESCRIPTOR.index -> builder.solutionStacks =
                    deserializer.deserializeList(SOLUTIONSTACKS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
