// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed health information about an Amazon EC2 instance in your Elastic Beanstalk environment.
 */
class SingleInstanceHealth private constructor(builder: Builder) {
    /**
     * Request metrics from your application.
     */
    val applicationMetrics: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics? = builder.applicationMetrics
    /**
     * The availability zone in which the instance runs.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Represents the causes, which provide more information about the current health status.
     */
    val causes: List<String>? = builder.causes
    /**
     * Represents the color indicator that gives you information about the health of the EC2 instance. For more information, see [Health Colors and Statuses](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
     */
    val color: kotlin.String? = builder.color
    /**
     * Information about the most recent deployment to an instance.
     */
    val deployment: aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment? = builder.deployment
    /**
     * Returns the health status of the specified instance. For more information, see [Health Colors and Statuses](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
     */
    val healthStatus: kotlin.String? = builder.healthStatus
    /**
     * The ID of the Amazon EC2 instance.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The instance's type.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The time at which the EC2 instance was launched.
     */
    val launchedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.launchedAt
    /**
     * Operating system metrics from the instance.
     */
    val system: aws.sdk.kotlin.services.elasticbeanstalk.model.SystemStatus? = builder.system

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.SingleInstanceHealth = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SingleInstanceHealth(")
        append("applicationMetrics=$applicationMetrics,")
        append("availabilityZone=$availabilityZone,")
        append("causes=$causes,")
        append("color=$color,")
        append("deployment=$deployment,")
        append("healthStatus=$healthStatus,")
        append("instanceId=$instanceId,")
        append("instanceType=$instanceType,")
        append("launchedAt=$launchedAt,")
        append("system=$system)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationMetrics?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (causes?.hashCode() ?: 0)
        result = 31 * result + (color?.hashCode() ?: 0)
        result = 31 * result + (deployment?.hashCode() ?: 0)
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (launchedAt?.hashCode() ?: 0)
        result = 31 * result + (system?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SingleInstanceHealth

        if (applicationMetrics != other.applicationMetrics) return false
        if (availabilityZone != other.availabilityZone) return false
        if (causes != other.causes) return false
        if (color != other.color) return false
        if (deployment != other.deployment) return false
        if (healthStatus != other.healthStatus) return false
        if (instanceId != other.instanceId) return false
        if (instanceType != other.instanceType) return false
        if (launchedAt != other.launchedAt) return false
        if (system != other.system) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.SingleInstanceHealth = Builder(this).apply(block).build()

    class Builder {
        /**
         * Request metrics from your application.
         */
        var applicationMetrics: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics? = null
        /**
         * The availability zone in which the instance runs.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * Represents the causes, which provide more information about the current health status.
         */
        var causes: List<String>? = null
        /**
         * Represents the color indicator that gives you information about the health of the EC2 instance. For more information, see [Health Colors and Statuses](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
         */
        var color: kotlin.String? = null
        /**
         * Information about the most recent deployment to an instance.
         */
        var deployment: aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment? = null
        /**
         * Returns the health status of the specified instance. For more information, see [Health Colors and Statuses](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
         */
        var healthStatus: kotlin.String? = null
        /**
         * The ID of the Amazon EC2 instance.
         */
        var instanceId: kotlin.String? = null
        /**
         * The instance's type.
         */
        var instanceType: kotlin.String? = null
        /**
         * The time at which the EC2 instance was launched.
         */
        var launchedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Operating system metrics from the instance.
         */
        var system: aws.sdk.kotlin.services.elasticbeanstalk.model.SystemStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.SingleInstanceHealth) : this() {
            this.applicationMetrics = x.applicationMetrics
            this.availabilityZone = x.availabilityZone
            this.causes = x.causes
            this.color = x.color
            this.deployment = x.deployment
            this.healthStatus = x.healthStatus
            this.instanceId = x.instanceId
            this.instanceType = x.instanceType
            this.launchedAt = x.launchedAt
            this.system = x.system
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.SingleInstanceHealth = SingleInstanceHealth(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics] inside the given [block]
         */
        fun applicationMetrics(block: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics.Builder.() -> kotlin.Unit) {
            this.applicationMetrics = aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment] inside the given [block]
         */
        fun deployment(block: aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment.Builder.() -> kotlin.Unit) {
            this.deployment = aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.SystemStatus] inside the given [block]
         */
        fun system(block: aws.sdk.kotlin.services.elasticbeanstalk.model.SystemStatus.Builder.() -> kotlin.Unit) {
            this.system = aws.sdk.kotlin.services.elasticbeanstalk.model.SystemStatus.invoke(block)
        }
    }
}
