// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse
import aws.sdk.kotlin.services.elasticache.model.ReservedCacheNode
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class PurchaseReservedCacheNodesOfferingOperationDeserializer: HttpDeserialize<PurchaseReservedCacheNodesOfferingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PurchaseReservedCacheNodesOfferingResponse {
        if (!response.status.isSuccess()) {
            throwPurchaseReservedCacheNodesOfferingError(context, response)
        }
        val builder = PurchaseReservedCacheNodesOfferingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePurchaseReservedCacheNodesOfferingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPurchaseReservedCacheNodesOfferingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ReservedCacheNodeAlreadyExists" -> ReservedCacheNodeAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedCacheNodeQuotaExceeded" -> ReservedCacheNodeQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "ReservedCacheNodesOfferingNotFound" -> ReservedCacheNodesOfferingNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePurchaseReservedCacheNodesOfferingOperationBody(builder: PurchaseReservedCacheNodesOfferingResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PurchaseReservedCacheNodesOfferingResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("PurchaseReservedCacheNodesOfferingResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap PurchaseReservedCacheNodesOffering response")
    }
    // end unwrap response wrapper

    val RESERVEDCACHENODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ReservedCacheNode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticache.amazonaws.com/doc/2015-02-02/"))
        trait(XmlSerialName("PurchaseReservedCacheNodesOfferingResult"))
        field(RESERVEDCACHENODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESERVEDCACHENODE_DESCRIPTOR.index -> builder.reservedCacheNode = deserializeReservedCacheNodeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
