// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.transform

import aws.sdk.kotlin.services.elasticache.model.DeleteCacheSubnetGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteCacheSubnetGroupOperationDeserializer: HttpDeserialize<DeleteCacheSubnetGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteCacheSubnetGroupResponse {
        if (!response.status.isSuccess()) {
            throwDeleteCacheSubnetGroupError(context, response)
        }
        val builder = DeleteCacheSubnetGroupResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteCacheSubnetGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CacheSubnetGroupInUse" -> CacheSubnetGroupInUseDeserializer().deserialize(context, wrappedResponse)
        "CacheSubnetGroupNotFoundFault" -> CacheSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
