// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a copy of an entire Redis cluster as of the time when the snapshot was taken.
 */
public class Snapshot private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the snapshot.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean = builder.autoMinorVersionUpgrade
    /**
     * Indicates the status of automatic failover for the source Redis replication group.
     */
    public val automaticFailover: aws.sdk.kotlin.services.elasticache.model.AutomaticFailoverStatus? = builder.automaticFailover
    /**
     * The date and time when the source cluster was created.
     */
    public val cacheClusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.cacheClusterCreateTime
    /**
     * The user-supplied identifier of the source cluster.
     */
    public val cacheClusterId: kotlin.String? = builder.cacheClusterId
    /**
     * The name of the compute and memory capacity node type for the source cluster.
     *
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
     * + General purpose:
     *    + Current generation: **M6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`, `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`, `cache.m6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**M5 node types:**`cache.m5.large`, `cache.m5.xlarge`, `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`, `cache.m5.24xlarge`**M4 node types:**`cache.m4.large`, `cache.m4.xlarge`, `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`**T4g node types** (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`**T3 node types:**`cache.t3.micro`, `cache.t3.small`, `cache.t3.medium`**T2 node types:**`cache.t2.micro`, `cache.t2.small`, `cache.t2.medium`
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**T1 node types:**`cache.t1.micro`**M1 node types:**`cache.m1.small`, `cache.m1.medium`, `cache.m1.large`, `cache.m1.xlarge`**M3 node types:**`cache.m3.medium`, `cache.m3.large`, `cache.m3.xlarge`, `cache.m3.2xlarge`
     * + Compute optimized:
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**C1 node types:**`cache.c1.xlarge`
     * + Memory optimized:
     *    + Current generation: **R6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).`cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`, `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`, `cache.r6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**R5 node types:**`cache.r5.large`, `cache.r5.xlarge`, `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`, `cache.r5.24xlarge`**R4 node types:**`cache.r4.large`, `cache.r4.xlarge`, `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`, `cache.r4.16xlarge`
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**M2 node types:**`cache.m2.xlarge`, `cache.m2.2xlarge`, `cache.m2.4xlarge`**R3 node types:**`cache.r3.large`, `cache.r3.xlarge`, `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
     *
     * **Additional node type info**
     * + All current generation instance types are created in Amazon VPC by default.
     * + Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * + Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * + Redis configuration variables `appendonly` and `appendfsync` are not supported on Redis version 2.8.22 and later.
     */
    public val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The cache parameter group that is associated with the source cluster.
     */
    public val cacheParameterGroupName: kotlin.String? = builder.cacheParameterGroupName
    /**
     * The name of the cache subnet group associated with the source cluster.
     */
    public val cacheSubnetGroupName: kotlin.String? = builder.cacheSubnetGroupName
    /**
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html).
     */
    public val dataTiering: aws.sdk.kotlin.services.elasticache.model.DataTieringStatus? = builder.dataTiering
    /**
     * The name of the cache engine (`memcached` or `redis`) used by the source cluster.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version of the cache engine version that is used by the source cluster.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The ID of the KMS key used to encrypt the snapshot.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * A list of the cache nodes in the source cluster.
     */
    public val nodeSnapshots: List<NodeSnapshot>? = builder.nodeSnapshots
    /**
     * The number of cache nodes in the source cluster.
     *
     * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
     */
    public val numCacheNodes: kotlin.Int? = builder.numCacheNodes
    /**
     * The number of node groups (shards) in this snapshot. When restoring from a snapshot, the number of node groups (shards) in the snapshot and in the restored replication group must be the same.
     */
    public val numNodeGroups: kotlin.Int? = builder.numNodeGroups
    /**
     * The port number used by each cache nodes in the source cluster.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The name of the Availability Zone in which the source cluster is located.
     */
    public val preferredAvailabilityZone: kotlin.String? = builder.preferredAvailabilityZone
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     *
     * Valid values for `ddd` are:
     * + `sun`
     * + `mon`
     * + `tue`
     * + `wed`
     * + `thu`
     * + `fri`
     * + `sat`
     *
     * Example: `sun:23:00-mon:01:30`
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The ARN (Amazon Resource Name) of the preferred outpost.
     */
    public val preferredOutpostArn: kotlin.String? = builder.preferredOutpostArn
    /**
     * A description of the source replication group.
     */
    public val replicationGroupDescription: kotlin.String? = builder.replicationGroupDescription
    /**
     * The unique identifier of the source replication group.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * The name of a snapshot. For an automatic snapshot, the name is system-generated. For a manual snapshot, this is the user-provided name.
     */
    public val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * For an automatic snapshot, the number of days for which ElastiCache retains the snapshot before deleting it.
     *
     * For manual snapshots, this field reflects the `SnapshotRetentionLimit` for the source cluster when the snapshot was created. This field is otherwise ignored: Manual snapshots do not expire, and can only be deleted using the `DeleteSnapshot` operation.
     *
     * **Important** If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * Indicates whether the snapshot is from an automatic backup (`automated`) or was created manually (`manual`).
     */
    public val snapshotSource: kotlin.String? = builder.snapshotSource
    /**
     * The status of the snapshot. Valid values: `creating` | `available` | `restoring` | `copying` | `deleting`.
     */
    public val snapshotStatus: kotlin.String? = builder.snapshotStatus
    /**
     * The daily time range during which ElastiCache takes daily snapshots of the source cluster.
     */
    public val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * The Amazon Resource Name (ARN) for the topic used by the source cluster for publishing notifications.
     */
    public val topicArn: kotlin.String? = builder.topicArn
    /**
     * The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group for the source cluster.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.Snapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("arn=$arn,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automaticFailover=$automaticFailover,")
        append("cacheClusterCreateTime=$cacheClusterCreateTime,")
        append("cacheClusterId=$cacheClusterId,")
        append("cacheNodeType=$cacheNodeType,")
        append("cacheParameterGroupName=$cacheParameterGroupName,")
        append("cacheSubnetGroupName=$cacheSubnetGroupName,")
        append("dataTiering=$dataTiering,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("nodeSnapshots=$nodeSnapshots,")
        append("numCacheNodes=$numCacheNodes,")
        append("numNodeGroups=$numNodeGroups,")
        append("port=$port,")
        append("preferredAvailabilityZone=$preferredAvailabilityZone,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("preferredOutpostArn=$preferredOutpostArn,")
        append("replicationGroupDescription=$replicationGroupDescription,")
        append("replicationGroupId=$replicationGroupId,")
        append("snapshotName=$snapshotName,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotSource=$snapshotSource,")
        append("snapshotStatus=$snapshotStatus,")
        append("snapshotWindow=$snapshotWindow,")
        append("topicArn=$topicArn,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (autoMinorVersionUpgrade.hashCode())
        result = 31 * result + (automaticFailover?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (cacheClusterId?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (cacheParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (cacheSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (dataTiering?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (nodeSnapshots?.hashCode() ?: 0)
        result = 31 * result + (numCacheNodes ?: 0)
        result = 31 * result + (numNodeGroups ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredOutpostArn?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotSource?.hashCode() ?: 0)
        result = 31 * result + (snapshotStatus?.hashCode() ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (topicArn?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Snapshot

        if (arn != other.arn) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automaticFailover != other.automaticFailover) return false
        if (cacheClusterCreateTime != other.cacheClusterCreateTime) return false
        if (cacheClusterId != other.cacheClusterId) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (cacheParameterGroupName != other.cacheParameterGroupName) return false
        if (cacheSubnetGroupName != other.cacheSubnetGroupName) return false
        if (dataTiering != other.dataTiering) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (nodeSnapshots != other.nodeSnapshots) return false
        if (numCacheNodes != other.numCacheNodes) return false
        if (numNodeGroups != other.numNodeGroups) return false
        if (port != other.port) return false
        if (preferredAvailabilityZone != other.preferredAvailabilityZone) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (preferredOutpostArn != other.preferredOutpostArn) return false
        if (replicationGroupDescription != other.replicationGroupDescription) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (snapshotName != other.snapshotName) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotSource != other.snapshotSource) return false
        if (snapshotStatus != other.snapshotStatus) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (topicArn != other.topicArn) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.Snapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the snapshot.
         */
        public var arn: kotlin.String? = null
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean = false
        /**
         * Indicates the status of automatic failover for the source Redis replication group.
         */
        public var automaticFailover: aws.sdk.kotlin.services.elasticache.model.AutomaticFailoverStatus? = null
        /**
         * The date and time when the source cluster was created.
         */
        public var cacheClusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-supplied identifier of the source cluster.
         */
        public var cacheClusterId: kotlin.String? = null
        /**
         * The name of the compute and memory capacity node type for the source cluster.
         *
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
         * + General purpose:
         *    + Current generation: **M6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`, `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`, `cache.m6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**M5 node types:**`cache.m5.large`, `cache.m5.xlarge`, `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`, `cache.m5.24xlarge`**M4 node types:**`cache.m4.large`, `cache.m4.xlarge`, `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`**T4g node types** (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`**T3 node types:**`cache.t3.micro`, `cache.t3.small`, `cache.t3.medium`**T2 node types:**`cache.t2.micro`, `cache.t2.small`, `cache.t2.medium`
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**T1 node types:**`cache.t1.micro`**M1 node types:**`cache.m1.small`, `cache.m1.medium`, `cache.m1.large`, `cache.m1.xlarge`**M3 node types:**`cache.m3.medium`, `cache.m3.large`, `cache.m3.xlarge`, `cache.m3.2xlarge`
         * + Compute optimized:
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**C1 node types:**`cache.c1.xlarge`
         * + Memory optimized:
         *    + Current generation: **R6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).`cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`, `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`, `cache.r6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**R5 node types:**`cache.r5.large`, `cache.r5.xlarge`, `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`, `cache.r5.24xlarge`**R4 node types:**`cache.r4.large`, `cache.r4.xlarge`, `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`, `cache.r4.16xlarge`
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**M2 node types:**`cache.m2.xlarge`, `cache.m2.2xlarge`, `cache.m2.4xlarge`**R3 node types:**`cache.r3.large`, `cache.r3.xlarge`, `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
         *
         * **Additional node type info**
         * + All current generation instance types are created in Amazon VPC by default.
         * + Redis append-only files (AOF) are not supported for T1 or T2 instances.
         * + Redis Multi-AZ with automatic failover is not supported on T1 instances.
         * + Redis configuration variables `appendonly` and `appendfsync` are not supported on Redis version 2.8.22 and later.
         */
        public var cacheNodeType: kotlin.String? = null
        /**
         * The cache parameter group that is associated with the source cluster.
         */
        public var cacheParameterGroupName: kotlin.String? = null
        /**
         * The name of the cache subnet group associated with the source cluster.
         */
        public var cacheSubnetGroupName: kotlin.String? = null
        /**
         * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html).
         */
        public var dataTiering: aws.sdk.kotlin.services.elasticache.model.DataTieringStatus? = null
        /**
         * The name of the cache engine (`memcached` or `redis`) used by the source cluster.
         */
        public var engine: kotlin.String? = null
        /**
         * The version of the cache engine version that is used by the source cluster.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The ID of the KMS key used to encrypt the snapshot.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * A list of the cache nodes in the source cluster.
         */
        public var nodeSnapshots: List<NodeSnapshot>? = null
        /**
         * The number of cache nodes in the source cluster.
         *
         * For clusters running Redis, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.
         */
        public var numCacheNodes: kotlin.Int? = null
        /**
         * The number of node groups (shards) in this snapshot. When restoring from a snapshot, the number of node groups (shards) in the snapshot and in the restored replication group must be the same.
         */
        public var numNodeGroups: kotlin.Int? = null
        /**
         * The port number used by each cache nodes in the source cluster.
         */
        public var port: kotlin.Int? = null
        /**
         * The name of the Availability Zone in which the source cluster is located.
         */
        public var preferredAvailabilityZone: kotlin.String? = null
        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         *
         * Valid values for `ddd` are:
         * + `sun`
         * + `mon`
         * + `tue`
         * + `wed`
         * + `thu`
         * + `fri`
         * + `sat`
         *
         * Example: `sun:23:00-mon:01:30`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The ARN (Amazon Resource Name) of the preferred outpost.
         */
        public var preferredOutpostArn: kotlin.String? = null
        /**
         * A description of the source replication group.
         */
        public var replicationGroupDescription: kotlin.String? = null
        /**
         * The unique identifier of the source replication group.
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * The name of a snapshot. For an automatic snapshot, the name is system-generated. For a manual snapshot, this is the user-provided name.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * For an automatic snapshot, the number of days for which ElastiCache retains the snapshot before deleting it.
         *
         * For manual snapshots, this field reflects the `SnapshotRetentionLimit` for the source cluster when the snapshot was created. This field is otherwise ignored: Manual snapshots do not expire, and can only be deleted using the `DeleteSnapshot` operation.
         *
         * **Important** If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * Indicates whether the snapshot is from an automatic backup (`automated`) or was created manually (`manual`).
         */
        public var snapshotSource: kotlin.String? = null
        /**
         * The status of the snapshot. Valid values: `creating` | `available` | `restoring` | `copying` | `deleting`.
         */
        public var snapshotStatus: kotlin.String? = null
        /**
         * The daily time range during which ElastiCache takes daily snapshots of the source cluster.
         */
        public var snapshotWindow: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the topic used by the source cluster for publishing notifications.
         */
        public var topicArn: kotlin.String? = null
        /**
         * The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group for the source cluster.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.Snapshot) : this() {
            this.arn = x.arn
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automaticFailover = x.automaticFailover
            this.cacheClusterCreateTime = x.cacheClusterCreateTime
            this.cacheClusterId = x.cacheClusterId
            this.cacheNodeType = x.cacheNodeType
            this.cacheParameterGroupName = x.cacheParameterGroupName
            this.cacheSubnetGroupName = x.cacheSubnetGroupName
            this.dataTiering = x.dataTiering
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.nodeSnapshots = x.nodeSnapshots
            this.numCacheNodes = x.numCacheNodes
            this.numNodeGroups = x.numNodeGroups
            this.port = x.port
            this.preferredAvailabilityZone = x.preferredAvailabilityZone
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.preferredOutpostArn = x.preferredOutpostArn
            this.replicationGroupDescription = x.replicationGroupDescription
            this.replicationGroupId = x.replicationGroupId
            this.snapshotName = x.snapshotName
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotSource = x.snapshotSource
            this.snapshotStatus = x.snapshotStatus
            this.snapshotWindow = x.snapshotWindow
            this.topicArn = x.topicArn
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.Snapshot = Snapshot(this)
    }
}
