// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An update that you can apply to your Redis clusters.
 */
public class ServiceUpdate private constructor(builder: Builder) {
    /**
     * Indicates whether the service update will be automatically applied once the recommended apply-by date has expired.
     */
    public val autoUpdateAfterRecommendedApplyByDate: kotlin.Boolean? = builder.autoUpdateAfterRecommendedApplyByDate
    /**
     * The Elasticache engine to which the update applies. Either Redis or Memcached
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The Elasticache engine version to which the update applies. Either Redis or Memcached engine version
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The estimated length of time the service update will take
     */
    public val estimatedUpdateTime: kotlin.String? = builder.estimatedUpdateTime
    /**
     * Provides details of the service update
     */
    public val serviceUpdateDescription: kotlin.String? = builder.serviceUpdateDescription
    /**
     * The date after which the service update is no longer available
     */
    public val serviceUpdateEndDate: aws.smithy.kotlin.runtime.time.Instant? = builder.serviceUpdateEndDate
    /**
     * The unique ID of the service update
     */
    public val serviceUpdateName: kotlin.String? = builder.serviceUpdateName
    /**
     * The recommendend date to apply the service update in order to ensure compliance. For information on compliance, see [Self-Service Security Updates for Compliance](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service).
     */
    public val serviceUpdateRecommendedApplyByDate: aws.smithy.kotlin.runtime.time.Instant? = builder.serviceUpdateRecommendedApplyByDate
    /**
     * The date when the service update is initially available
     */
    public val serviceUpdateReleaseDate: aws.smithy.kotlin.runtime.time.Instant? = builder.serviceUpdateReleaseDate
    /**
     * The severity of the service update
     */
    public val serviceUpdateSeverity: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateSeverity? = builder.serviceUpdateSeverity
    /**
     * The status of the service update
     */
    public val serviceUpdateStatus: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateStatus? = builder.serviceUpdateStatus
    /**
     * Reflects the nature of the service update
     */
    public val serviceUpdateType: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateType? = builder.serviceUpdateType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ServiceUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceUpdate(")
        append("autoUpdateAfterRecommendedApplyByDate=$autoUpdateAfterRecommendedApplyByDate,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("estimatedUpdateTime=$estimatedUpdateTime,")
        append("serviceUpdateDescription=$serviceUpdateDescription,")
        append("serviceUpdateEndDate=$serviceUpdateEndDate,")
        append("serviceUpdateName=$serviceUpdateName,")
        append("serviceUpdateRecommendedApplyByDate=$serviceUpdateRecommendedApplyByDate,")
        append("serviceUpdateReleaseDate=$serviceUpdateReleaseDate,")
        append("serviceUpdateSeverity=$serviceUpdateSeverity,")
        append("serviceUpdateStatus=$serviceUpdateStatus,")
        append("serviceUpdateType=$serviceUpdateType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoUpdateAfterRecommendedApplyByDate?.hashCode() ?: 0
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (estimatedUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateDescription?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateEndDate?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateName?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateRecommendedApplyByDate?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateReleaseDate?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateSeverity?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (serviceUpdateType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceUpdate

        if (autoUpdateAfterRecommendedApplyByDate != other.autoUpdateAfterRecommendedApplyByDate) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (estimatedUpdateTime != other.estimatedUpdateTime) return false
        if (serviceUpdateDescription != other.serviceUpdateDescription) return false
        if (serviceUpdateEndDate != other.serviceUpdateEndDate) return false
        if (serviceUpdateName != other.serviceUpdateName) return false
        if (serviceUpdateRecommendedApplyByDate != other.serviceUpdateRecommendedApplyByDate) return false
        if (serviceUpdateReleaseDate != other.serviceUpdateReleaseDate) return false
        if (serviceUpdateSeverity != other.serviceUpdateSeverity) return false
        if (serviceUpdateStatus != other.serviceUpdateStatus) return false
        if (serviceUpdateType != other.serviceUpdateType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ServiceUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether the service update will be automatically applied once the recommended apply-by date has expired.
         */
        public var autoUpdateAfterRecommendedApplyByDate: kotlin.Boolean? = null
        /**
         * The Elasticache engine to which the update applies. Either Redis or Memcached
         */
        public var engine: kotlin.String? = null
        /**
         * The Elasticache engine version to which the update applies. Either Redis or Memcached engine version
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The estimated length of time the service update will take
         */
        public var estimatedUpdateTime: kotlin.String? = null
        /**
         * Provides details of the service update
         */
        public var serviceUpdateDescription: kotlin.String? = null
        /**
         * The date after which the service update is no longer available
         */
        public var serviceUpdateEndDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID of the service update
         */
        public var serviceUpdateName: kotlin.String? = null
        /**
         * The recommendend date to apply the service update in order to ensure compliance. For information on compliance, see [Self-Service Security Updates for Compliance](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service).
         */
        public var serviceUpdateRecommendedApplyByDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date when the service update is initially available
         */
        public var serviceUpdateReleaseDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The severity of the service update
         */
        public var serviceUpdateSeverity: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateSeverity? = null
        /**
         * The status of the service update
         */
        public var serviceUpdateStatus: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateStatus? = null
        /**
         * Reflects the nature of the service update
         */
        public var serviceUpdateType: aws.sdk.kotlin.services.elasticache.model.ServiceUpdateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ServiceUpdate) : this() {
            this.autoUpdateAfterRecommendedApplyByDate = x.autoUpdateAfterRecommendedApplyByDate
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.estimatedUpdateTime = x.estimatedUpdateTime
            this.serviceUpdateDescription = x.serviceUpdateDescription
            this.serviceUpdateEndDate = x.serviceUpdateEndDate
            this.serviceUpdateName = x.serviceUpdateName
            this.serviceUpdateRecommendedApplyByDate = x.serviceUpdateRecommendedApplyByDate
            this.serviceUpdateReleaseDate = x.serviceUpdateReleaseDate
            this.serviceUpdateSeverity = x.serviceUpdateSeverity
            this.serviceUpdateStatus = x.serviceUpdateStatus
            this.serviceUpdateType = x.serviceUpdateType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ServiceUpdate = ServiceUpdate(this)
    }
}
