// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains all of the attributes of a specific Redis replication group.
 */
public class ReplicationGroup private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the replication group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A flag that enables encryption at-rest when set to `true`.
     *
     * You cannot modify the value of `AtRestEncryptionEnabled` after the cluster is created. To enable encryption at-rest on a cluster you must set `AtRestEncryptionEnabled` to `true` when you create a cluster.
     *
     * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
     *
     * Default: `false`
     */
    public val atRestEncryptionEnabled: kotlin.Boolean? = builder.atRestEncryptionEnabled
    /**
     * A flag that enables using an `AuthToken` (password) when issuing Redis commands.
     *
     * Default: `false`
     */
    public val authTokenEnabled: kotlin.Boolean? = builder.authTokenEnabled
    /**
     * The date the auth token was last modified
     */
    public val authTokenLastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.authTokenLastModifiedDate
    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean = builder.autoMinorVersionUpgrade
    /**
     * Indicates the status of automatic failover for this Redis replication group.
     */
    public val automaticFailover: aws.sdk.kotlin.services.elasticache.model.AutomaticFailoverStatus? = builder.automaticFailover
    /**
     * The name of the compute and memory capacity node type for each node in the replication group.
     */
    public val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be partitioned across multiple shards (API/CLI: node groups).
     *
     * Valid values: `true` | `false`
     */
    public val clusterEnabled: kotlin.Boolean? = builder.clusterEnabled
    /**
     * The configuration endpoint for this replication group. Use the configuration endpoint to connect to this replication group.
     */
    public val configurationEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = builder.configurationEndpoint
    /**
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html).
     */
    public val dataTiering: aws.sdk.kotlin.services.elasticache.model.DataTieringStatus? = builder.dataTiering
    /**
     * The user supplied description of the replication group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the Global datastore and role of this replication group in the Global datastore.
     */
    public val globalReplicationGroupInfo: aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroupInfo? = builder.globalReplicationGroupInfo
    /**
     * The network type you choose when modifying a cluster, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
     */
    public val ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = builder.ipDiscovery
    /**
     * The ID of the KMS key used to encrypt the disk in the cluster.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Returns the destination, format and type of the logs.
     */
    public val logDeliveryConfigurations: List<LogDeliveryConfiguration>? = builder.logDeliveryConfigurations
    /**
     * The names of all the cache clusters that are part of this replication group.
     */
    public val memberClusters: List<String>? = builder.memberClusters
    /**
     * The outpost ARNs of the replication group's member clusters.
     */
    public val memberClustersOutpostArns: List<String>? = builder.memberClustersOutpostArns
    /**
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see [Minimizing Downtime: Multi-AZ](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html)
     */
    public val multiAz: aws.sdk.kotlin.services.elasticache.model.MultiAzStatus? = builder.multiAz
    /**
     * Must be either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
     */
    public val networkType: aws.sdk.kotlin.services.elasticache.model.NetworkType? = builder.networkType
    /**
     * A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups, this is a single-element list. For Redis (cluster mode enabled) replication groups, the list contains an entry for each node group (shard).
     */
    public val nodeGroups: List<NodeGroup>? = builder.nodeGroups
    /**
     * A group of settings to be applied to the replication group, either immediately or during the next maintenance window.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.elasticache.model.ReplicationGroupPendingModifiedValues? = builder.pendingModifiedValues
    /**
     * The date and time when the cluster was created.
     */
    public val replicationGroupCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.replicationGroupCreateTime
    /**
     * The identifier for the replication group.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     *
     *  If the value of `SnapshotRetentionLimit` is set to zero (0), backups are turned off.
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     *
     * Example: `05:00-09:00`
     *
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     *
     * This parameter is only valid if the `Engine` parameter is `redis`.
     */
    public val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * The cluster ID that is used as the daily snapshot source for the replication group.
     */
    public val snapshottingClusterId: kotlin.String? = builder.snapshottingClusterId
    /**
     * The current state of this replication group - `creating`, `available`, `modifying`, `deleting`, `create-failed`, `snapshotting`.
     */
    public val status: kotlin.String? = builder.status
    /**
     * A flag that enables in-transit encryption when set to `true`.
     *
     * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
     *
     * Default: `false`
     */
    public val transitEncryptionEnabled: kotlin.Boolean? = builder.transitEncryptionEnabled
    /**
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     */
    public val transitEncryptionMode: aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode? = builder.transitEncryptionMode
    /**
     * The ID of the user group associated to the replication group.
     */
    public val userGroupIds: List<String>? = builder.userGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.ReplicationGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationGroup(")
        append("arn=$arn,")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("authTokenEnabled=$authTokenEnabled,")
        append("authTokenLastModifiedDate=$authTokenLastModifiedDate,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automaticFailover=$automaticFailover,")
        append("cacheNodeType=$cacheNodeType,")
        append("clusterEnabled=$clusterEnabled,")
        append("configurationEndpoint=$configurationEndpoint,")
        append("dataTiering=$dataTiering,")
        append("description=$description,")
        append("globalReplicationGroupInfo=$globalReplicationGroupInfo,")
        append("ipDiscovery=$ipDiscovery,")
        append("kmsKeyId=$kmsKeyId,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("memberClusters=$memberClusters,")
        append("memberClustersOutpostArns=$memberClustersOutpostArns,")
        append("multiAz=$multiAz,")
        append("networkType=$networkType,")
        append("nodeGroups=$nodeGroups,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("replicationGroupCreateTime=$replicationGroupCreateTime,")
        append("replicationGroupId=$replicationGroupId,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("snapshottingClusterId=$snapshottingClusterId,")
        append("status=$status,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("transitEncryptionMode=$transitEncryptionMode,")
        append("userGroupIds=$userGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (atRestEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (authTokenEnabled?.hashCode() ?: 0)
        result = 31 * result + (authTokenLastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade.hashCode())
        result = 31 * result + (automaticFailover?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (clusterEnabled?.hashCode() ?: 0)
        result = 31 * result + (configurationEndpoint?.hashCode() ?: 0)
        result = 31 * result + (dataTiering?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (globalReplicationGroupInfo?.hashCode() ?: 0)
        result = 31 * result + (ipDiscovery?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (memberClusters?.hashCode() ?: 0)
        result = 31 * result + (memberClustersOutpostArns?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (nodeGroups?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupCreateTime?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (snapshottingClusterId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionMode?.hashCode() ?: 0)
        result = 31 * result + (userGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationGroup

        if (arn != other.arn) return false
        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (authTokenEnabled != other.authTokenEnabled) return false
        if (authTokenLastModifiedDate != other.authTokenLastModifiedDate) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automaticFailover != other.automaticFailover) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (clusterEnabled != other.clusterEnabled) return false
        if (configurationEndpoint != other.configurationEndpoint) return false
        if (dataTiering != other.dataTiering) return false
        if (description != other.description) return false
        if (globalReplicationGroupInfo != other.globalReplicationGroupInfo) return false
        if (ipDiscovery != other.ipDiscovery) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (memberClusters != other.memberClusters) return false
        if (memberClustersOutpostArns != other.memberClustersOutpostArns) return false
        if (multiAz != other.multiAz) return false
        if (networkType != other.networkType) return false
        if (nodeGroups != other.nodeGroups) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (replicationGroupCreateTime != other.replicationGroupCreateTime) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (snapshottingClusterId != other.snapshottingClusterId) return false
        if (status != other.status) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (transitEncryptionMode != other.transitEncryptionMode) return false
        if (userGroupIds != other.userGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.ReplicationGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the replication group.
         */
        public var arn: kotlin.String? = null
        /**
         * A flag that enables encryption at-rest when set to `true`.
         *
         * You cannot modify the value of `AtRestEncryptionEnabled` after the cluster is created. To enable encryption at-rest on a cluster you must set `AtRestEncryptionEnabled` to `true` when you create a cluster.
         *
         * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
         *
         * Default: `false`
         */
        public var atRestEncryptionEnabled: kotlin.Boolean? = null
        /**
         * A flag that enables using an `AuthToken` (password) when issuing Redis commands.
         *
         * Default: `false`
         */
        public var authTokenEnabled: kotlin.Boolean? = null
        /**
         * The date the auth token was last modified
         */
        public var authTokenLastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean = false
        /**
         * Indicates the status of automatic failover for this Redis replication group.
         */
        public var automaticFailover: aws.sdk.kotlin.services.elasticache.model.AutomaticFailoverStatus? = null
        /**
         * The name of the compute and memory capacity node type for each node in the replication group.
         */
        public var cacheNodeType: kotlin.String? = null
        /**
         * A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be partitioned across multiple shards (API/CLI: node groups).
         *
         * Valid values: `true` | `false`
         */
        public var clusterEnabled: kotlin.Boolean? = null
        /**
         * The configuration endpoint for this replication group. Use the configuration endpoint to connect to this replication group.
         */
        public var configurationEndpoint: aws.sdk.kotlin.services.elasticache.model.Endpoint? = null
        /**
         * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html).
         */
        public var dataTiering: aws.sdk.kotlin.services.elasticache.model.DataTieringStatus? = null
        /**
         * The user supplied description of the replication group.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the Global datastore and role of this replication group in the Global datastore.
         */
        public var globalReplicationGroupInfo: aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroupInfo? = null
        /**
         * The network type you choose when modifying a cluster, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
         */
        public var ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = null
        /**
         * The ID of the KMS key used to encrypt the disk in the cluster.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Returns the destination, format and type of the logs.
         */
        public var logDeliveryConfigurations: List<LogDeliveryConfiguration>? = null
        /**
         * The names of all the cache clusters that are part of this replication group.
         */
        public var memberClusters: List<String>? = null
        /**
         * The outpost ARNs of the replication group's member clusters.
         */
        public var memberClustersOutpostArns: List<String>? = null
        /**
         * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see [Minimizing Downtime: Multi-AZ](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html)
         */
        public var multiAz: aws.sdk.kotlin.services.elasticache.model.MultiAzStatus? = null
        /**
         * Must be either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
         */
        public var networkType: aws.sdk.kotlin.services.elasticache.model.NetworkType? = null
        /**
         * A list of node groups in this replication group. For Redis (cluster mode disabled) replication groups, this is a single-element list. For Redis (cluster mode enabled) replication groups, the list contains an entry for each node group (shard).
         */
        public var nodeGroups: List<NodeGroup>? = null
        /**
         * A group of settings to be applied to the replication group, either immediately or during the next maintenance window.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.elasticache.model.ReplicationGroupPendingModifiedValues? = null
        /**
         * The date and time when the cluster was created.
         */
        public var replicationGroupCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier for the replication group.
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         *
         *  If the value of `SnapshotRetentionLimit` is set to zero (0), backups are turned off.
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
         *
         * Example: `05:00-09:00`
         *
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         *
         * This parameter is only valid if the `Engine` parameter is `redis`.
         */
        public var snapshotWindow: kotlin.String? = null
        /**
         * The cluster ID that is used as the daily snapshot source for the replication group.
         */
        public var snapshottingClusterId: kotlin.String? = null
        /**
         * The current state of this replication group - `creating`, `available`, `modifying`, `deleting`, `create-failed`, `snapshotting`.
         */
        public var status: kotlin.String? = null
        /**
         * A flag that enables in-transit encryption when set to `true`.
         *
         * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
         *
         * Default: `false`
         */
        public var transitEncryptionEnabled: kotlin.Boolean? = null
        /**
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         */
        public var transitEncryptionMode: aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode? = null
        /**
         * The ID of the user group associated to the replication group.
         */
        public var userGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.ReplicationGroup) : this() {
            this.arn = x.arn
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.authTokenEnabled = x.authTokenEnabled
            this.authTokenLastModifiedDate = x.authTokenLastModifiedDate
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automaticFailover = x.automaticFailover
            this.cacheNodeType = x.cacheNodeType
            this.clusterEnabled = x.clusterEnabled
            this.configurationEndpoint = x.configurationEndpoint
            this.dataTiering = x.dataTiering
            this.description = x.description
            this.globalReplicationGroupInfo = x.globalReplicationGroupInfo
            this.ipDiscovery = x.ipDiscovery
            this.kmsKeyId = x.kmsKeyId
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.memberClusters = x.memberClusters
            this.memberClustersOutpostArns = x.memberClustersOutpostArns
            this.multiAz = x.multiAz
            this.networkType = x.networkType
            this.nodeGroups = x.nodeGroups
            this.pendingModifiedValues = x.pendingModifiedValues
            this.replicationGroupCreateTime = x.replicationGroupCreateTime
            this.replicationGroupId = x.replicationGroupId
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.snapshottingClusterId = x.snapshottingClusterId
            this.status = x.status
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.transitEncryptionMode = x.transitEncryptionMode
            this.userGroupIds = x.userGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.ReplicationGroup = ReplicationGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.Endpoint] inside the given [block]
         */
        public fun configurationEndpoint(block: aws.sdk.kotlin.services.elasticache.model.Endpoint.Builder.() -> kotlin.Unit) {
            this.configurationEndpoint = aws.sdk.kotlin.services.elasticache.model.Endpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroupInfo] inside the given [block]
         */
        public fun globalReplicationGroupInfo(block: aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroupInfo.Builder.() -> kotlin.Unit) {
            this.globalReplicationGroupInfo = aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroupInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.ReplicationGroupPendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.elasticache.model.ReplicationGroupPendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.elasticache.model.ReplicationGroupPendingModifiedValues.invoke(block)
        }
    }
}
