// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model



/**
 * Represents the input of a `CreateReplicationGroup` operation.
 */
public class CreateReplicationGroupRequest private constructor(builder: Builder) {
    /**
     * A flag that enables encryption at rest when set to `true`.
     *
     * You cannot modify the value of `AtRestEncryptionEnabled` after the replication group is created. To enable encryption at rest on a replication group you must set `AtRestEncryptionEnabled` to `true` when you create the replication group.
     *
     * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
     *
     * Default: `false`
     */
    public val atRestEncryptionEnabled: kotlin.Boolean? = builder.atRestEncryptionEnabled
    /**
     * **Reserved parameter.** The password used to access a password protected server.
     *
     * `AuthToken` can be specified only on replication groups where `TransitEncryptionEnabled` is `true`.
     *
     * For HIPAA compliance, you must specify `TransitEncryptionEnabled` as `true`, an `AuthToken`, and a `CacheSubnetGroup`.
     *
     * Password constraints:
     * + Must be only printable ASCII characters.
     * + Must be at least 16 characters and no more than 128 characters in length.
     * + The only permitted printable special characters are !, &, #, $, ^, <, >, and -. Other printable special characters cannot be used in the AUTH token.
     *
     * For more information, see [AUTH password](http://redis.io/commands/AUTH) at http://redis.io/commands/AUTH.
     */
    public val authToken: kotlin.String? = builder.authToken
    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
     *
     * `AutomaticFailoverEnabled` must be enabled for Redis (cluster mode enabled) replication groups.
     *
     * Default: false
     */
    public val automaticFailoverEnabled: kotlin.Boolean? = builder.automaticFailoverEnabled
    /**
     * The compute and memory capacity of the nodes in the node group (shard).
     *
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
     * + General purpose:
     *    + Current generation: **M6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`, `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`, `cache.m6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**M5 node types:**`cache.m5.large`, `cache.m5.xlarge`, `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`, `cache.m5.24xlarge`**M4 node types:**`cache.m4.large`, `cache.m4.xlarge`, `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`**T4g node types** (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`**T3 node types:**`cache.t3.micro`, `cache.t3.small`, `cache.t3.medium`**T2 node types:**`cache.t2.micro`, `cache.t2.small`, `cache.t2.medium`
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**T1 node types:**`cache.t1.micro`**M1 node types:**`cache.m1.small`, `cache.m1.medium`, `cache.m1.large`, `cache.m1.xlarge`**M3 node types:**`cache.m3.medium`, `cache.m3.large`, `cache.m3.xlarge`, `cache.m3.2xlarge`
     * + Compute optimized:
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**C1 node types:**`cache.c1.xlarge`
     * + Memory optimized:
     *    + Current generation: **R6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).`cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`, `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`, `cache.r6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**R5 node types:**`cache.r5.large`, `cache.r5.xlarge`, `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`, `cache.r5.24xlarge`**R4 node types:**`cache.r4.large`, `cache.r4.xlarge`, `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`, `cache.r4.16xlarge`
     *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**M2 node types:**`cache.m2.xlarge`, `cache.m2.2xlarge`, `cache.m2.4xlarge`**R3 node types:**`cache.r3.large`, `cache.r3.xlarge`, `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
     *
     * **Additional node type info**
     * + All current generation instance types are created in Amazon VPC by default.
     * + Redis append-only files (AOF) are not supported for T1 or T2 instances.
     * + Redis Multi-AZ with automatic failover is not supported on T1 instances.
     * + Redis configuration variables `appendonly` and `appendfsync` are not supported on Redis version 2.8.22 and later.
     */
    public val cacheNodeType: kotlin.String? = builder.cacheNodeType
    /**
     * The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.
     *
     * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name.
     * + To create a Redis (cluster mode disabled) replication group, use `CacheParameterGroupName=default.redis3.2`.
     * + To create a Redis (cluster mode enabled) replication group, use `CacheParameterGroupName=default.redis3.2.cluster.on`.
     */
    public val cacheParameterGroupName: kotlin.String? = builder.cacheParameterGroupName
    /**
     * A list of cache security group names to associate with this replication group.
     */
    public val cacheSecurityGroupNames: List<String>? = builder.cacheSecurityGroupNames
    /**
     * The name of the cache subnet group to be used for the replication group.
     *
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see [Subnets and Subnet Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
     */
    public val cacheSubnetGroupName: kotlin.String? = builder.cacheSubnetGroupName
    /**
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html).
     */
    public val dataTieringEnabled: kotlin.Boolean? = builder.dataTieringEnabled
    /**
     * The name of the cache engine to be used for the clusters in this replication group. The value must be set to `Redis`.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the `DescribeCacheEngineVersions` operation.
     *
     * **Important:** You can upgrade to a newer engine version (see [Selecting a Cache Engine and Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)) in the *ElastiCache User Guide*, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The name of the Global datastore
     */
    public val globalReplicationGroupId: kotlin.String? = builder.globalReplicationGroupId
    /**
     * The network type you choose when creating a replication group, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
     */
    public val ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = builder.ipDiscovery
    /**
     * The ID of the KMS key used to encrypt the disk in the cluster.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies the destination, format and type of the logs.
     */
    public val logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = builder.logDeliveryConfigurations
    /**
     * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see [Minimizing Downtime: Multi-AZ](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html).
     */
    public val multiAzEnabled: kotlin.Boolean? = builder.multiAzEnabled
    /**
     * Must be either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
     */
    public val networkType: aws.sdk.kotlin.services.elasticache.model.NetworkType? = builder.networkType
    /**
     * A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: `PrimaryAvailabilityZone`, `ReplicaAvailabilityZones`, `ReplicaCount`, and `Slots`.
     *
     * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.
     */
    public val nodeGroupConfiguration: List<NodeGroupConfiguration>? = builder.nodeGroupConfiguration
    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     *
     * The Amazon SNS topic owner must be the same as the cluster owner.
     */
    public val notificationTopicArn: kotlin.String? = builder.notificationTopicArn
    /**
     * The number of clusters this replication group initially has.
     *
     * This parameter is not used if there is more than one node group (shard). You should use `ReplicasPerNodeGroup` instead.
     *
     * If `AutomaticFailoverEnabled` is `true`, the value of this parameter must be at least 2. If `AutomaticFailoverEnabled` is `false` you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.
     *
     * The maximum permitted value for `NumCacheClusters` is 6 (1 primary plus 5 replicas).
     */
    public val numCacheClusters: kotlin.Int? = builder.numCacheClusters
    /**
     * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
     *
     * Default: 1
     */
    public val numNodeGroups: kotlin.Int? = builder.numNodeGroups
    /**
     * The port number on which each member of the replication group accepts connections.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.
     *
     * This parameter is not used if there is more than one node group (shard). You should use `NodeGroupConfiguration` instead.
     *
     * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.
     *
     * The number of Availability Zones listed must equal the value of `NumCacheClusters`.
     *
     * Default: system chosen Availability Zones.
     */
    public val preferredCacheClusterAZs: List<String>? = builder.preferredCacheClusterAZs
    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for `ddd` are:
     *
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     *
     * Valid values for `ddd` are:
     * + `sun`
     * + `mon`
     * + `tue`
     * + `wed`
     * + `thu`
     * + `fri`
     * + `sat`
     *
     * Example: `sun:23:00-mon:01:30`
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of `available`.
     *
     * This parameter is not required if `NumCacheClusters`, `NumNodeGroups`, or `ReplicasPerNodeGroup` is specified.
     */
    public val primaryClusterId: kotlin.String? = builder.primaryClusterId
    /**
     * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.
     */
    public val replicasPerNodeGroup: kotlin.Int? = builder.replicasPerNodeGroup
    /**
     * A user-created description for the replication group.
     */
    public val replicationGroupDescription: kotlin.String? = builder.replicationGroupDescription
    /**
     * The replication group identifier. This parameter is stored as a lowercase string.
     *
     * Constraints:
     * + A name must contain from 1 to 40 alphanumeric characters or hyphens.
     * + The first character must be a letter.
     * + A name cannot end with a hyphen or contain two consecutive hyphens.
     */
    public val replicationGroupId: kotlin.String? = builder.replicationGroupId
    /**
     * One or more Amazon VPC security groups associated with this replication group.
     *
     * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter *NumNodeGroups* or the number of node groups configured by *NodeGroupConfiguration* regardless of the number of ARNs specified here.
     *
     * Example of an Amazon S3 ARN: `arn:aws:s3:::my_bucket/snapshot1.rdb`
     */
    public val snapshotArns: List<String>? = builder.snapshotArns
    /**
     * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to `restoring` while the new replication group is being created.
     */
    public val snapshotName: kotlin.String? = builder.snapshotName
    /**
     * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
     *
     * Default: 0 (i.e., automatic backups are disabled for this cluster).
     */
    public val snapshotRetentionLimit: kotlin.Int? = builder.snapshotRetentionLimit
    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     *
     * Example: `05:00-09:00`
     *
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     */
    public val snapshotWindow: kotlin.String? = builder.snapshotWindow
    /**
     * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=`myKey`, Value=`myKeyValue`. You can include multiple tags as shown following: Key=`myKey`, Value=`myKeyValue` Key=`mySecondKey`, Value=`mySecondKeyValue`. Tags on replication groups will be replicated to all nodes.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A flag that enables in-transit encryption when set to `true`.
     *
     * This parameter is valid only if the `Engine` parameter is `redis`, the `EngineVersion` parameter is `3.2.6`, `4.x` or later, and the cluster is being created in an Amazon VPC.
     *
     * If you enable in-transit encryption, you must also specify a value for `CacheSubnetGroup`.
     *
     * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
     *
     * Default: `false`
     *
     * For HIPAA compliance, you must specify `TransitEncryptionEnabled` as `true`, an `AuthToken`, and a `CacheSubnetGroup`.
     */
    public val transitEncryptionEnabled: kotlin.Boolean? = builder.transitEncryptionEnabled
    /**
     * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
     *
     * When setting `TransitEncryptionEnabled` to `true`, you can set your `TransitEncryptionMode` to `preferred` in the same request, to allow both encrypted and unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections you can modify the value to `required` to allow encrypted connections only.
     *
     * Setting `TransitEncryptionMode` to `required` is a two-step process that requires you to first set the `TransitEncryptionMode` to `preferred` first, after that you can set `TransitEncryptionMode` to `required`.
     */
    public val transitEncryptionMode: aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode? = builder.transitEncryptionMode
    /**
     * The user group to associate with the replication group.
     */
    public val userGroupIds: List<String>? = builder.userGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.CreateReplicationGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateReplicationGroupRequest(")
        append("atRestEncryptionEnabled=$atRestEncryptionEnabled,")
        append("authToken=$authToken,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automaticFailoverEnabled=$automaticFailoverEnabled,")
        append("cacheNodeType=$cacheNodeType,")
        append("cacheParameterGroupName=$cacheParameterGroupName,")
        append("cacheSecurityGroupNames=$cacheSecurityGroupNames,")
        append("cacheSubnetGroupName=$cacheSubnetGroupName,")
        append("dataTieringEnabled=$dataTieringEnabled,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("globalReplicationGroupId=$globalReplicationGroupId,")
        append("ipDiscovery=$ipDiscovery,")
        append("kmsKeyId=$kmsKeyId,")
        append("logDeliveryConfigurations=$logDeliveryConfigurations,")
        append("multiAzEnabled=$multiAzEnabled,")
        append("networkType=$networkType,")
        append("nodeGroupConfiguration=$nodeGroupConfiguration,")
        append("notificationTopicArn=$notificationTopicArn,")
        append("numCacheClusters=$numCacheClusters,")
        append("numNodeGroups=$numNodeGroups,")
        append("port=$port,")
        append("preferredCacheClusterAZs=$preferredCacheClusterAZs,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("primaryClusterId=$primaryClusterId,")
        append("replicasPerNodeGroup=$replicasPerNodeGroup,")
        append("replicationGroupDescription=$replicationGroupDescription,")
        append("replicationGroupId=$replicationGroupId,")
        append("securityGroupIds=$securityGroupIds,")
        append("snapshotArns=$snapshotArns,")
        append("snapshotName=$snapshotName,")
        append("snapshotRetentionLimit=$snapshotRetentionLimit,")
        append("snapshotWindow=$snapshotWindow,")
        append("tags=$tags,")
        append("transitEncryptionEnabled=$transitEncryptionEnabled,")
        append("transitEncryptionMode=$transitEncryptionMode,")
        append("userGroupIds=$userGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = atRestEncryptionEnabled?.hashCode() ?: 0
        result = 31 * result + (authToken?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (automaticFailoverEnabled?.hashCode() ?: 0)
        result = 31 * result + (cacheNodeType?.hashCode() ?: 0)
        result = 31 * result + (cacheParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (cacheSecurityGroupNames?.hashCode() ?: 0)
        result = 31 * result + (cacheSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (dataTieringEnabled?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalReplicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (ipDiscovery?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logDeliveryConfigurations?.hashCode() ?: 0)
        result = 31 * result + (multiAzEnabled?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (nodeGroupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (notificationTopicArn?.hashCode() ?: 0)
        result = 31 * result + (numCacheClusters ?: 0)
        result = 31 * result + (numNodeGroups ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredCacheClusterAZs?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (primaryClusterId?.hashCode() ?: 0)
        result = 31 * result + (replicasPerNodeGroup ?: 0)
        result = 31 * result + (replicationGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (replicationGroupId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (snapshotArns?.hashCode() ?: 0)
        result = 31 * result + (snapshotName?.hashCode() ?: 0)
        result = 31 * result + (snapshotRetentionLimit ?: 0)
        result = 31 * result + (snapshotWindow?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionEnabled?.hashCode() ?: 0)
        result = 31 * result + (transitEncryptionMode?.hashCode() ?: 0)
        result = 31 * result + (userGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateReplicationGroupRequest

        if (atRestEncryptionEnabled != other.atRestEncryptionEnabled) return false
        if (authToken != other.authToken) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automaticFailoverEnabled != other.automaticFailoverEnabled) return false
        if (cacheNodeType != other.cacheNodeType) return false
        if (cacheParameterGroupName != other.cacheParameterGroupName) return false
        if (cacheSecurityGroupNames != other.cacheSecurityGroupNames) return false
        if (cacheSubnetGroupName != other.cacheSubnetGroupName) return false
        if (dataTieringEnabled != other.dataTieringEnabled) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (globalReplicationGroupId != other.globalReplicationGroupId) return false
        if (ipDiscovery != other.ipDiscovery) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (logDeliveryConfigurations != other.logDeliveryConfigurations) return false
        if (multiAzEnabled != other.multiAzEnabled) return false
        if (networkType != other.networkType) return false
        if (nodeGroupConfiguration != other.nodeGroupConfiguration) return false
        if (notificationTopicArn != other.notificationTopicArn) return false
        if (numCacheClusters != other.numCacheClusters) return false
        if (numNodeGroups != other.numNodeGroups) return false
        if (port != other.port) return false
        if (preferredCacheClusterAZs != other.preferredCacheClusterAZs) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (primaryClusterId != other.primaryClusterId) return false
        if (replicasPerNodeGroup != other.replicasPerNodeGroup) return false
        if (replicationGroupDescription != other.replicationGroupDescription) return false
        if (replicationGroupId != other.replicationGroupId) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (snapshotArns != other.snapshotArns) return false
        if (snapshotName != other.snapshotName) return false
        if (snapshotRetentionLimit != other.snapshotRetentionLimit) return false
        if (snapshotWindow != other.snapshotWindow) return false
        if (tags != other.tags) return false
        if (transitEncryptionEnabled != other.transitEncryptionEnabled) return false
        if (transitEncryptionMode != other.transitEncryptionMode) return false
        if (userGroupIds != other.userGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.CreateReplicationGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A flag that enables encryption at rest when set to `true`.
         *
         * You cannot modify the value of `AtRestEncryptionEnabled` after the replication group is created. To enable encryption at rest on a replication group you must set `AtRestEncryptionEnabled` to `true` when you create the replication group.
         *
         * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
         *
         * Default: `false`
         */
        public var atRestEncryptionEnabled: kotlin.Boolean? = null
        /**
         * **Reserved parameter.** The password used to access a password protected server.
         *
         * `AuthToken` can be specified only on replication groups where `TransitEncryptionEnabled` is `true`.
         *
         * For HIPAA compliance, you must specify `TransitEncryptionEnabled` as `true`, an `AuthToken`, and a `CacheSubnetGroup`.
         *
         * Password constraints:
         * + Must be only printable ASCII characters.
         * + Must be at least 16 characters and no more than 128 characters in length.
         * + The only permitted printable special characters are !, &, #, $, ^, <, >, and -. Other printable special characters cannot be used in the AUTH token.
         *
         * For more information, see [AUTH password](http://redis.io/commands/AUTH) at http://redis.io/commands/AUTH.
         */
        public var authToken: kotlin.String? = null
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.
         *
         * `AutomaticFailoverEnabled` must be enabled for Redis (cluster mode enabled) replication groups.
         *
         * Default: false
         */
        public var automaticFailoverEnabled: kotlin.Boolean? = null
        /**
         * The compute and memory capacity of the nodes in the node group (shard).
         *
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.
         * + General purpose:
         *    + Current generation: **M6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): `cache.m6g.large`, `cache.m6g.xlarge`, `cache.m6g.2xlarge`, `cache.m6g.4xlarge`, `cache.m6g.8xlarge`, `cache.m6g.12xlarge`, `cache.m6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**M5 node types:**`cache.m5.large`, `cache.m5.xlarge`, `cache.m5.2xlarge`, `cache.m5.4xlarge`, `cache.m5.12xlarge`, `cache.m5.24xlarge`**M4 node types:**`cache.m4.large`, `cache.m4.xlarge`, `cache.m4.2xlarge`, `cache.m4.4xlarge`, `cache.m4.10xlarge`**T4g node types** (available only for Redis engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): `cache.t4g.micro`, `cache.t4g.small`, `cache.t4g.medium`**T3 node types:**`cache.t3.micro`, `cache.t3.small`, `cache.t3.medium`**T2 node types:**`cache.t2.micro`, `cache.t2.small`, `cache.t2.medium`
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**T1 node types:**`cache.t1.micro`**M1 node types:**`cache.m1.small`, `cache.m1.medium`, `cache.m1.large`, `cache.m1.xlarge`**M3 node types:**`cache.m3.medium`, `cache.m3.large`, `cache.m3.xlarge`, `cache.m3.2xlarge`
         * + Compute optimized:
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**C1 node types:**`cache.c1.xlarge`
         * + Memory optimized:
         *    + Current generation: **R6g node types** (available only for Redis engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward).`cache.r6g.large`, `cache.r6g.xlarge`, `cache.r6g.2xlarge`, `cache.r6g.4xlarge`, `cache.r6g.8xlarge`, `cache.r6g.12xlarge`, `cache.r6g.16xlarge`For region availability, see [Supported Node Types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)**R5 node types:**`cache.r5.large`, `cache.r5.xlarge`, `cache.r5.2xlarge`, `cache.r5.4xlarge`, `cache.r5.12xlarge`, `cache.r5.24xlarge`**R4 node types:**`cache.r4.large`, `cache.r4.xlarge`, `cache.r4.2xlarge`, `cache.r4.4xlarge`, `cache.r4.8xlarge`, `cache.r4.16xlarge`
         *    + Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)**M2 node types:**`cache.m2.xlarge`, `cache.m2.2xlarge`, `cache.m2.4xlarge`**R3 node types:**`cache.r3.large`, `cache.r3.xlarge`, `cache.r3.2xlarge`, `cache.r3.4xlarge`, `cache.r3.8xlarge`
         *
         * **Additional node type info**
         * + All current generation instance types are created in Amazon VPC by default.
         * + Redis append-only files (AOF) are not supported for T1 or T2 instances.
         * + Redis Multi-AZ with automatic failover is not supported on T1 instances.
         * + Redis configuration variables `appendonly` and `appendfsync` are not supported on Redis version 2.8.22 and later.
         */
        public var cacheNodeType: kotlin.String? = null
        /**
         * The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.
         *
         * If you are running Redis version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name.
         * + To create a Redis (cluster mode disabled) replication group, use `CacheParameterGroupName=default.redis3.2`.
         * + To create a Redis (cluster mode enabled) replication group, use `CacheParameterGroupName=default.redis3.2.cluster.on`.
         */
        public var cacheParameterGroupName: kotlin.String? = null
        /**
         * A list of cache security group names to associate with this replication group.
         */
        public var cacheSecurityGroupNames: List<String>? = null
        /**
         * The name of the cache subnet group to be used for the replication group.
         *
         * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see [Subnets and Subnet Groups](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html).
         */
        public var cacheSubnetGroupName: kotlin.String? = null
        /**
         * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see [Data tiering](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html).
         */
        public var dataTieringEnabled: kotlin.Boolean? = null
        /**
         * The name of the cache engine to be used for the clusters in this replication group. The value must be set to `Redis`.
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the `DescribeCacheEngineVersions` operation.
         *
         * **Important:** You can upgrade to a newer engine version (see [Selecting a Cache Engine and Version](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement)) in the *ElastiCache User Guide*, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The name of the Global datastore
         */
        public var globalReplicationGroupId: kotlin.String? = null
        /**
         * The network type you choose when creating a replication group, either `ipv4` | `ipv6`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
         */
        public var ipDiscovery: aws.sdk.kotlin.services.elasticache.model.IpDiscovery? = null
        /**
         * The ID of the KMS key used to encrypt the disk in the cluster.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies the destination, format and type of the logs.
         */
        public var logDeliveryConfigurations: List<LogDeliveryConfigurationRequest>? = null
        /**
         * A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see [Minimizing Downtime: Multi-AZ](http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html).
         */
        public var multiAzEnabled: kotlin.Boolean? = null
        /**
         * Must be either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the [Nitro system](https://aws.amazon.com/ec2/nitro/).
         */
        public var networkType: aws.sdk.kotlin.services.elasticache.model.NetworkType? = null
        /**
         * A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: `PrimaryAvailabilityZone`, `ReplicaAvailabilityZones`, `ReplicaCount`, and `Slots`.
         *
         * If you're creating a Redis (cluster mode disabled) or a Redis (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.
         */
        public var nodeGroupConfiguration: List<NodeGroupConfiguration>? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
         *
         * The Amazon SNS topic owner must be the same as the cluster owner.
         */
        public var notificationTopicArn: kotlin.String? = null
        /**
         * The number of clusters this replication group initially has.
         *
         * This parameter is not used if there is more than one node group (shard). You should use `ReplicasPerNodeGroup` instead.
         *
         * If `AutomaticFailoverEnabled` is `true`, the value of this parameter must be at least 2. If `AutomaticFailoverEnabled` is `false` you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.
         *
         * The maximum permitted value for `NumCacheClusters` is 6 (1 primary plus 5 replicas).
         */
        public var numCacheClusters: kotlin.Int? = null
        /**
         * An optional parameter that specifies the number of node groups (shards) for this Redis (cluster mode enabled) replication group. For Redis (cluster mode disabled) either omit this parameter or set it to 1.
         *
         * Default: 1
         */
        public var numNodeGroups: kotlin.Int? = null
        /**
         * The port number on which each member of the replication group accepts connections.
         */
        public var port: kotlin.Int? = null
        /**
         * A list of EC2 Availability Zones in which the replication group's clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.
         *
         * This parameter is not used if there is more than one node group (shard). You should use `NodeGroupConfiguration` instead.
         *
         * If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.
         *
         * The number of Availability Zones listed must equal the value of `NumCacheClusters`.
         *
         * Default: system chosen Availability Zones.
         */
        public var preferredCacheClusterAZs: List<String>? = null
        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for `ddd` are:
         *
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         *
         * Valid values for `ddd` are:
         * + `sun`
         * + `mon`
         * + `tue`
         * + `wed`
         * + `thu`
         * + `fri`
         * + `sat`
         *
         * Example: `sun:23:00-mon:01:30`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of `available`.
         *
         * This parameter is not required if `NumCacheClusters`, `NumNodeGroups`, or `ReplicasPerNodeGroup` is specified.
         */
        public var primaryClusterId: kotlin.String? = null
        /**
         * An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.
         */
        public var replicasPerNodeGroup: kotlin.Int? = null
        /**
         * A user-created description for the replication group.
         */
        public var replicationGroupDescription: kotlin.String? = null
        /**
         * The replication group identifier. This parameter is stored as a lowercase string.
         *
         * Constraints:
         * + A name must contain from 1 to 40 alphanumeric characters or hyphens.
         * + The first character must be a letter.
         * + A name cannot end with a hyphen or contain two consecutive hyphens.
         */
        public var replicationGroupId: kotlin.String? = null
        /**
         * One or more Amazon VPC security groups associated with this replication group.
         *
         * Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of Amazon Resource Names (ARN) that uniquely identify the Redis RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter *NumNodeGroups* or the number of node groups configured by *NodeGroupConfiguration* regardless of the number of ARNs specified here.
         *
         * Example of an Amazon S3 ARN: `arn:aws:s3:::my_bucket/snapshot1.rdb`
         */
        public var snapshotArns: List<String>? = null
        /**
         * The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to `restoring` while the new replication group is being created.
         */
        public var snapshotName: kotlin.String? = null
        /**
         * The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set `SnapshotRetentionLimit` to 5, a snapshot that was taken today is retained for 5 days before being deleted.
         *
         * Default: 0 (i.e., automatic backups are disabled for this cluster).
         */
        public var snapshotRetentionLimit: kotlin.Int? = null
        /**
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
         *
         * Example: `05:00-09:00`
         *
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         */
        public var snapshotWindow: kotlin.String? = null
        /**
         * A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=`myKey`, Value=`myKeyValue`. You can include multiple tags as shown following: Key=`myKey`, Value=`myKeyValue` Key=`mySecondKey`, Value=`mySecondKeyValue`. Tags on replication groups will be replicated to all nodes.
         */
        public var tags: List<Tag>? = null
        /**
         * A flag that enables in-transit encryption when set to `true`.
         *
         * This parameter is valid only if the `Engine` parameter is `redis`, the `EngineVersion` parameter is `3.2.6`, `4.x` or later, and the cluster is being created in an Amazon VPC.
         *
         * If you enable in-transit encryption, you must also specify a value for `CacheSubnetGroup`.
         *
         * **Required:** Only available when creating a replication group in an Amazon VPC using redis version `3.2.6`, `4.x` or later.
         *
         * Default: `false`
         *
         * For HIPAA compliance, you must specify `TransitEncryptionEnabled` as `true`, an `AuthToken`, and a `CacheSubnetGroup`.
         */
        public var transitEncryptionEnabled: kotlin.Boolean? = null
        /**
         * A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.
         *
         * When setting `TransitEncryptionEnabled` to `true`, you can set your `TransitEncryptionMode` to `preferred` in the same request, to allow both encrypted and unencrypted connections at the same time. Once you migrate all your Redis clients to use encrypted connections you can modify the value to `required` to allow encrypted connections only.
         *
         * Setting `TransitEncryptionMode` to `required` is a two-step process that requires you to first set the `TransitEncryptionMode` to `preferred` first, after that you can set `TransitEncryptionMode` to `required`.
         */
        public var transitEncryptionMode: aws.sdk.kotlin.services.elasticache.model.TransitEncryptionMode? = null
        /**
         * The user group to associate with the replication group.
         */
        public var userGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.CreateReplicationGroupRequest) : this() {
            this.atRestEncryptionEnabled = x.atRestEncryptionEnabled
            this.authToken = x.authToken
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automaticFailoverEnabled = x.automaticFailoverEnabled
            this.cacheNodeType = x.cacheNodeType
            this.cacheParameterGroupName = x.cacheParameterGroupName
            this.cacheSecurityGroupNames = x.cacheSecurityGroupNames
            this.cacheSubnetGroupName = x.cacheSubnetGroupName
            this.dataTieringEnabled = x.dataTieringEnabled
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.globalReplicationGroupId = x.globalReplicationGroupId
            this.ipDiscovery = x.ipDiscovery
            this.kmsKeyId = x.kmsKeyId
            this.logDeliveryConfigurations = x.logDeliveryConfigurations
            this.multiAzEnabled = x.multiAzEnabled
            this.networkType = x.networkType
            this.nodeGroupConfiguration = x.nodeGroupConfiguration
            this.notificationTopicArn = x.notificationTopicArn
            this.numCacheClusters = x.numCacheClusters
            this.numNodeGroups = x.numNodeGroups
            this.port = x.port
            this.preferredCacheClusterAZs = x.preferredCacheClusterAZs
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.primaryClusterId = x.primaryClusterId
            this.replicasPerNodeGroup = x.replicasPerNodeGroup
            this.replicationGroupDescription = x.replicationGroupDescription
            this.replicationGroupId = x.replicationGroupId
            this.securityGroupIds = x.securityGroupIds
            this.snapshotArns = x.snapshotArns
            this.snapshotName = x.snapshotName
            this.snapshotRetentionLimit = x.snapshotRetentionLimit
            this.snapshotWindow = x.snapshotWindow
            this.tags = x.tags
            this.transitEncryptionEnabled = x.transitEncryptionEnabled
            this.transitEncryptionMode = x.transitEncryptionMode
            this.userGroupIds = x.userGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.CreateReplicationGroupRequest = CreateReplicationGroupRequest(this)
    }
}
