// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ReplicationGroup
import aws.sdk.kotlin.services.elasticache.model.TestFailoverResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class TestFailoverOperationDeserializer: HttpDeserializer.NonStreaming<TestFailoverResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): TestFailoverResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwTestFailoverError(context, call, payload)
        }
        val builder = TestFailoverResponse.Builder()

        if (payload != null) {
            deserializeTestFailoverOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwTestFailoverError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "APICallRateForCustomerExceeded" -> ApiCallRateForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCacheClusterState" -> InvalidCacheClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidKMSKeyFault" -> InvalidKmsKeyFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReplicationGroupState" -> InvalidReplicationGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NodeGroupNotFoundFault" -> NodeGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReplicationGroupNotFoundFault" -> ReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TestFailoverNotAvailableFault" -> TestFailoverNotAvailableFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTestFailoverOperationBody(builder: TestFailoverResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "TestFailover")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReplicationGroup com.amazonaws.elasticache#TestFailoverResult$ReplicationGroup
            "ReplicationGroup" -> builder.replicationGroup = deserializeReplicationGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
