// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.AutomaticFailoverStatus
import aws.sdk.kotlin.services.elasticache.model.DataTieringStatus
import aws.sdk.kotlin.services.elasticache.model.Snapshot
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeSnapshotDocument(reader: XmlTagReader): Snapshot {
    val builder = Snapshot.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // SnapshotName com.amazonaws.elasticache#Snapshot$SnapshotName
            "SnapshotName" -> builder.snapshotName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // ReplicationGroupId com.amazonaws.elasticache#Snapshot$ReplicationGroupId
            "ReplicationGroupId" -> builder.replicationGroupId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // ReplicationGroupDescription com.amazonaws.elasticache#Snapshot$ReplicationGroupDescription
            "ReplicationGroupDescription" -> builder.replicationGroupDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheClusterId com.amazonaws.elasticache#Snapshot$CacheClusterId
            "CacheClusterId" -> builder.cacheClusterId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // SnapshotStatus com.amazonaws.elasticache#Snapshot$SnapshotStatus
            "SnapshotStatus" -> builder.snapshotStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // SnapshotSource com.amazonaws.elasticache#Snapshot$SnapshotSource
            "SnapshotSource" -> builder.snapshotSource = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheNodeType com.amazonaws.elasticache#Snapshot$CacheNodeType
            "CacheNodeType" -> builder.cacheNodeType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Engine com.amazonaws.elasticache#Snapshot$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // EngineVersion com.amazonaws.elasticache#Snapshot$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // NumCacheNodes com.amazonaws.elasticache#Snapshot$NumCacheNodes
            "NumCacheNodes" -> builder.numCacheNodes = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticache#IntegerOptional`)" }
            // PreferredAvailabilityZone com.amazonaws.elasticache#Snapshot$PreferredAvailabilityZone
            "PreferredAvailabilityZone" -> builder.preferredAvailabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // PreferredOutpostArn com.amazonaws.elasticache#Snapshot$PreferredOutpostArn
            "PreferredOutpostArn" -> builder.preferredOutpostArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheClusterCreateTime com.amazonaws.elasticache#Snapshot$CacheClusterCreateTime
            "CacheClusterCreateTime" -> builder.cacheClusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticache#TStamp`)" }
            // PreferredMaintenanceWindow com.amazonaws.elasticache#Snapshot$PreferredMaintenanceWindow
            "PreferredMaintenanceWindow" -> builder.preferredMaintenanceWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // TopicArn com.amazonaws.elasticache#Snapshot$TopicArn
            "TopicArn" -> builder.topicArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Port com.amazonaws.elasticache#Snapshot$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticache#IntegerOptional`)" }
            // CacheParameterGroupName com.amazonaws.elasticache#Snapshot$CacheParameterGroupName
            "CacheParameterGroupName" -> builder.cacheParameterGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheSubnetGroupName com.amazonaws.elasticache#Snapshot$CacheSubnetGroupName
            "CacheSubnetGroupName" -> builder.cacheSubnetGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // VpcId com.amazonaws.elasticache#Snapshot$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // AutoMinorVersionUpgrade com.amazonaws.elasticache#Snapshot$AutoMinorVersionUpgrade
            "AutoMinorVersionUpgrade" -> builder.autoMinorVersionUpgrade = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticache#Boolean`)" }
            // SnapshotRetentionLimit com.amazonaws.elasticache#Snapshot$SnapshotRetentionLimit
            "SnapshotRetentionLimit" -> builder.snapshotRetentionLimit = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticache#IntegerOptional`)" }
            // SnapshotWindow com.amazonaws.elasticache#Snapshot$SnapshotWindow
            "SnapshotWindow" -> builder.snapshotWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // NumNodeGroups com.amazonaws.elasticache#Snapshot$NumNodeGroups
            "NumNodeGroups" -> builder.numNodeGroups = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticache#IntegerOptional`)" }
            // AutomaticFailover com.amazonaws.elasticache#Snapshot$AutomaticFailover
            "AutomaticFailover" -> builder.automaticFailover = curr.tryData()
                .parse { AutomaticFailoverStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#AutomaticFailoverStatus`)" }
            // NodeSnapshots com.amazonaws.elasticache#Snapshot$NodeSnapshots
            "NodeSnapshots" -> builder.nodeSnapshots = deserializeNodeSnapshotListShape(curr)
            // KmsKeyId com.amazonaws.elasticache#Snapshot$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // ARN com.amazonaws.elasticache#Snapshot$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // DataTiering com.amazonaws.elasticache#Snapshot$DataTiering
            "DataTiering" -> builder.dataTiering = curr.tryData()
                .parse { DataTieringStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticache#DataTieringStatus`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
