// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.ServerlessCache
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeServerlessCacheDocument(reader: XmlTagReader): ServerlessCache {
    val builder = ServerlessCache.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ServerlessCacheName com.amazonaws.elasticache#ServerlessCache$ServerlessCacheName
            "ServerlessCacheName" -> builder.serverlessCacheName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Description com.amazonaws.elasticache#ServerlessCache$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CreateTime com.amazonaws.elasticache#ServerlessCache$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticache#TStamp`)" }
            // Status com.amazonaws.elasticache#ServerlessCache$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Engine com.amazonaws.elasticache#ServerlessCache$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // MajorEngineVersion com.amazonaws.elasticache#ServerlessCache$MajorEngineVersion
            "MajorEngineVersion" -> builder.majorEngineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // FullEngineVersion com.amazonaws.elasticache#ServerlessCache$FullEngineVersion
            "FullEngineVersion" -> builder.fullEngineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // CacheUsageLimits com.amazonaws.elasticache#ServerlessCache$CacheUsageLimits
            "CacheUsageLimits" -> builder.cacheUsageLimits = deserializeCacheUsageLimitsDocument(curr)
            // KmsKeyId com.amazonaws.elasticache#ServerlessCache$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // SecurityGroupIds com.amazonaws.elasticache#ServerlessCache$SecurityGroupIds
            "SecurityGroupIds" -> builder.securityGroupIds = deserializeSecurityGroupIdsListShape(curr)
            // Endpoint com.amazonaws.elasticache#ServerlessCache$Endpoint
            "Endpoint" -> builder.endpoint = deserializeEndpointDocument(curr)
            // ReaderEndpoint com.amazonaws.elasticache#ServerlessCache$ReaderEndpoint
            "ReaderEndpoint" -> builder.readerEndpoint = deserializeEndpointDocument(curr)
            // ARN com.amazonaws.elasticache#ServerlessCache$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UserGroupId com.amazonaws.elasticache#ServerlessCache$UserGroupId
            "UserGroupId" -> builder.userGroupId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // SubnetIds com.amazonaws.elasticache#ServerlessCache$SubnetIds
            "SubnetIds" -> builder.subnetIds = deserializeSubnetIdsListShape(curr)
            // SnapshotRetentionLimit com.amazonaws.elasticache#ServerlessCache$SnapshotRetentionLimit
            "SnapshotRetentionLimit" -> builder.snapshotRetentionLimit = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticache#IntegerOptional`)" }
            // DailySnapshotTime com.amazonaws.elasticache#ServerlessCache$DailySnapshotTime
            "DailySnapshotTime" -> builder.dailySnapshotTime = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
