// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.PurchaseReservedCacheNodesOfferingResponse
import aws.sdk.kotlin.services.elasticache.model.ReservedCacheNode
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class PurchaseReservedCacheNodesOfferingOperationDeserializer: HttpDeserializer.NonStreaming<PurchaseReservedCacheNodesOfferingResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PurchaseReservedCacheNodesOfferingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPurchaseReservedCacheNodesOfferingError(context, call, payload)
        }
        val builder = PurchaseReservedCacheNodesOfferingResponse.Builder()

        if (payload != null) {
            deserializePurchaseReservedCacheNodesOfferingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPurchaseReservedCacheNodesOfferingError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedCacheNodeAlreadyExists" -> ReservedCacheNodeAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedCacheNodeQuotaExceeded" -> ReservedCacheNodeQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedCacheNodesOfferingNotFound" -> ReservedCacheNodesOfferingNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePurchaseReservedCacheNodesOfferingOperationBody(builder: PurchaseReservedCacheNodesOfferingResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "PurchaseReservedCacheNodesOffering")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReservedCacheNode com.amazonaws.elasticache#PurchaseReservedCacheNodesOfferingResult$ReservedCacheNode
            "ReservedCacheNode" -> builder.reservedCacheNode = deserializeReservedCacheNodeDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
