// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.elasticache.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListTagsForResourceOperationDeserializer: HttpDeserializer.NonStreaming<ListTagsForResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListTagsForResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListTagsForResourceError(context, call, payload)
        }
        val builder = ListTagsForResourceResponse.Builder()

        if (payload != null) {
            deserializeListTagsForResourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListTagsForResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CacheClusterNotFound" -> CacheClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheParameterGroupNotFound" -> CacheParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheSecurityGroupNotFound" -> CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheSubnetGroupNotFoundFault" -> CacheSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidARN" -> InvalidArnFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReplicationGroupState" -> InvalidReplicationGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidServerlessCacheSnapshotStateFault" -> InvalidServerlessCacheSnapshotStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidServerlessCacheStateFault" -> InvalidServerlessCacheStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReplicationGroupNotFoundFault" -> ReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ReservedCacheNodeNotFound" -> ReservedCacheNodeNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ServerlessCacheNotFoundFault" -> ServerlessCacheNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ServerlessCacheSnapshotNotFoundFault" -> ServerlessCacheSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotNotFoundFault" -> SnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UserGroupNotFound" -> UserGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotFound" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTagsForResourceOperationBody(builder: ListTagsForResourceResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ListTagsForResource")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // TagList com.amazonaws.elasticache#TagListMessage$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
