// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.GlobalReplicationGroup
import aws.sdk.kotlin.services.elasticache.model.IncreaseNodeGroupsInGlobalReplicationGroupResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class IncreaseNodeGroupsInGlobalReplicationGroupOperationDeserializer: HttpDeserializer.NonStreaming<IncreaseNodeGroupsInGlobalReplicationGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): IncreaseNodeGroupsInGlobalReplicationGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwIncreaseNodeGroupsInGlobalReplicationGroupError(context, call, payload)
        }
        val builder = IncreaseNodeGroupsInGlobalReplicationGroupResponse.Builder()

        if (payload != null) {
            deserializeIncreaseNodeGroupsInGlobalReplicationGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwIncreaseNodeGroupsInGlobalReplicationGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "GlobalReplicationGroupNotFoundFault" -> GlobalReplicationGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGlobalReplicationGroupState" -> InvalidGlobalReplicationGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeIncreaseNodeGroupsInGlobalReplicationGroupOperationBody(builder: IncreaseNodeGroupsInGlobalReplicationGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "IncreaseNodeGroupsInGlobalReplicationGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // GlobalReplicationGroup com.amazonaws.elasticache#IncreaseNodeGroupsInGlobalReplicationGroupResult$GlobalReplicationGroup
            "GlobalReplicationGroup" -> builder.globalReplicationGroup = deserializeGlobalReplicationGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
