// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.DescribeUpdateActionsResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.UpdateAction
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeUpdateActionsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeUpdateActionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeUpdateActionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeUpdateActionsError(context, call, payload)
        }
        val builder = DescribeUpdateActionsResponse.Builder()

        if (payload != null) {
            deserializeDescribeUpdateActionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeUpdateActionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeUpdateActionsOperationBody(builder: DescribeUpdateActionsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeUpdateActions")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Marker com.amazonaws.elasticache#UpdateActionsMessage$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UpdateActions com.amazonaws.elasticache#UpdateActionsMessage$UpdateActions
            "UpdateActions" -> builder.updateActions = deserializeUpdateActionListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
