// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CacheParameterGroup
import aws.sdk.kotlin.services.elasticache.model.DescribeCacheParameterGroupsResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeCacheParameterGroupsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeCacheParameterGroupsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeCacheParameterGroupsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCacheParameterGroupsError(context, call, payload)
        }
        val builder = DescribeCacheParameterGroupsResponse.Builder()

        if (payload != null) {
            deserializeDescribeCacheParameterGroupsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeCacheParameterGroupsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CacheParameterGroupNotFound" -> CacheParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCacheParameterGroupsOperationBody(builder: DescribeCacheParameterGroupsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeCacheParameterGroups")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CacheParameterGroups com.amazonaws.elasticache#CacheParameterGroupsMessage$CacheParameterGroups
            "CacheParameterGroups" -> builder.cacheParameterGroups = deserializeCacheParameterGroupListShape(curr)
            // Marker com.amazonaws.elasticache#CacheParameterGroupsMessage$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
