// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.DeleteUserGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.UserGroupPendingChanges
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DeleteUserGroupOperationDeserializer: HttpDeserializer.NonStreaming<DeleteUserGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteUserGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteUserGroupError(context, call, payload)
        }
        val builder = DeleteUserGroupResponse.Builder()

        if (payload != null) {
            deserializeDeleteUserGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteUserGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidUserGroupState" -> InvalidUserGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UserGroupNotFound" -> UserGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteUserGroupOperationBody(builder: DeleteUserGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DeleteUserGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ARN com.amazonaws.elasticache#UserGroup$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Engine com.amazonaws.elasticache#UserGroup$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#EngineType`)" }
            // MinimumEngineVersion com.amazonaws.elasticache#UserGroup$MinimumEngineVersion
            "MinimumEngineVersion" -> builder.minimumEngineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // PendingChanges com.amazonaws.elasticache#UserGroup$PendingChanges
            "PendingChanges" -> builder.pendingChanges = deserializeUserGroupPendingChangesDocument(curr)
            // ReplicationGroups com.amazonaws.elasticache#UserGroup$ReplicationGroups
            "ReplicationGroups" -> builder.replicationGroups = deserializeUGReplicationGroupIdListShape(curr)
            // ServerlessCaches com.amazonaws.elasticache#UserGroup$ServerlessCaches
            "ServerlessCaches" -> builder.serverlessCaches = deserializeUGServerlessCacheIdListShape(curr)
            // Status com.amazonaws.elasticache#UserGroup$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UserGroupId com.amazonaws.elasticache#UserGroup$UserGroupId
            "UserGroupId" -> builder.userGroupId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UserIds com.amazonaws.elasticache#UserGroup$UserIds
            "UserIds" -> builder.userIds = deserializeUserIdListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
