// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.Authentication
import aws.sdk.kotlin.services.elasticache.model.CreateUserResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateUserOperationDeserializer: HttpDeserializer.NonStreaming<CreateUserResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateUserResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateUserError(context, call, payload)
        }
        val builder = CreateUserResponse.Builder()

        if (payload != null) {
            deserializeCreateUserOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateUserError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateUserName" -> DuplicateUserNameFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "UserAlreadyExists" -> UserAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UserQuotaExceeded" -> UserQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUserOperationBody(builder: CreateUserResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateUser")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ARN com.amazonaws.elasticache#User$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // AccessString com.amazonaws.elasticache#User$AccessString
            "AccessString" -> builder.accessString = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Authentication com.amazonaws.elasticache#User$Authentication
            "Authentication" -> builder.authentication = deserializeAuthenticationDocument(curr)
            // Engine com.amazonaws.elasticache#User$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#EngineType`)" }
            // MinimumEngineVersion com.amazonaws.elasticache#User$MinimumEngineVersion
            "MinimumEngineVersion" -> builder.minimumEngineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Status com.amazonaws.elasticache#User$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UserGroupIds com.amazonaws.elasticache#User$UserGroupIds
            "UserGroupIds" -> builder.userGroupIds = deserializeUserGroupIdListShape(curr)
            // UserId com.amazonaws.elasticache#User$UserId
            "UserId" -> builder.userId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UserName com.amazonaws.elasticache#User$UserName
            "UserName" -> builder.userName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
