// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CreateUserGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.UserGroupPendingChanges
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateUserGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateUserGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateUserGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateUserGroupError(context, call, payload)
        }
        val builder = CreateUserGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateUserGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateUserGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DefaultUserRequired" -> DefaultUserRequiredDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateUserName" -> DuplicateUserNameFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "UserGroupAlreadyExists" -> UserGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UserGroupQuotaExceeded" -> UserGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotFound" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUserGroupOperationBody(builder: CreateUserGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateUserGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ARN com.amazonaws.elasticache#UserGroup$ARN
            "ARN" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // Engine com.amazonaws.elasticache#UserGroup$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#EngineType`)" }
            // MinimumEngineVersion com.amazonaws.elasticache#UserGroup$MinimumEngineVersion
            "MinimumEngineVersion" -> builder.minimumEngineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // PendingChanges com.amazonaws.elasticache#UserGroup$PendingChanges
            "PendingChanges" -> builder.pendingChanges = deserializeUserGroupPendingChangesDocument(curr)
            // ReplicationGroups com.amazonaws.elasticache#UserGroup$ReplicationGroups
            "ReplicationGroups" -> builder.replicationGroups = deserializeUGReplicationGroupIdListShape(curr)
            // ServerlessCaches com.amazonaws.elasticache#UserGroup$ServerlessCaches
            "ServerlessCaches" -> builder.serverlessCaches = deserializeUGServerlessCacheIdListShape(curr)
            // Status com.amazonaws.elasticache#UserGroup$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UserGroupId com.amazonaws.elasticache#UserGroup$UserGroupId
            "UserGroupId" -> builder.userGroupId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticache#String`)" }
            // UserIds com.amazonaws.elasticache#UserGroup$UserIds
            "UserIds" -> builder.userIds = deserializeUserIdListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
