// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.CacheSecurityGroup
import aws.sdk.kotlin.services.elasticache.model.CreateCacheSecurityGroupResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateCacheSecurityGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateCacheSecurityGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateCacheSecurityGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCacheSecurityGroupError(context, call, payload)
        }
        val builder = CreateCacheSecurityGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateCacheSecurityGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateCacheSecurityGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CacheSecurityGroupAlreadyExists" -> CacheSecurityGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "QuotaExceeded.CacheSecurityGroup" -> CacheSecurityGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCacheSecurityGroupOperationBody(builder: CreateCacheSecurityGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateCacheSecurityGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CacheSecurityGroup com.amazonaws.elasticache#CreateCacheSecurityGroupResult$CacheSecurityGroup
            "CacheSecurityGroup" -> builder.cacheSecurityGroup = deserializeCacheSecurityGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
