// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.BatchStopUpdateActionResponse
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.sdk.kotlin.services.elasticache.model.ProcessedUpdateAction
import aws.sdk.kotlin.services.elasticache.model.UnprocessedUpdateAction
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class BatchStopUpdateActionOperationDeserializer: HttpDeserializer.NonStreaming<BatchStopUpdateActionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchStopUpdateActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchStopUpdateActionError(context, call, payload)
        }
        val builder = BatchStopUpdateActionResponse.Builder()

        if (payload != null) {
            deserializeBatchStopUpdateActionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchStopUpdateActionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUpdateNotFoundFault" -> ServiceUpdateNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchStopUpdateActionOperationBody(builder: BatchStopUpdateActionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "BatchStopUpdateAction")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ProcessedUpdateActions com.amazonaws.elasticache#UpdateActionResultsMessage$ProcessedUpdateActions
            "ProcessedUpdateActions" -> builder.processedUpdateActions = deserializeProcessedUpdateActionListShape(curr)
            // UnprocessedUpdateActions com.amazonaws.elasticache#UpdateActionResultsMessage$UnprocessedUpdateActions
            "UnprocessedUpdateActions" -> builder.unprocessedUpdateActions = deserializeUnprocessedUpdateActionListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
