// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.serde

import aws.sdk.kotlin.services.elasticache.model.AuthorizeCacheSecurityGroupIngressResponse
import aws.sdk.kotlin.services.elasticache.model.CacheSecurityGroup
import aws.sdk.kotlin.services.elasticache.model.ElastiCacheException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AuthorizeCacheSecurityGroupIngressOperationDeserializer: HttpDeserializer.NonStreaming<AuthorizeCacheSecurityGroupIngressResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AuthorizeCacheSecurityGroupIngressResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAuthorizeCacheSecurityGroupIngressError(context, call, payload)
        }
        val builder = AuthorizeCacheSecurityGroupIngressResponse.Builder()

        if (payload != null) {
            deserializeAuthorizeCacheSecurityGroupIngressOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAuthorizeCacheSecurityGroupIngressError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElastiCacheException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthorizationAlreadyExists" -> AuthorizationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CacheSecurityGroupNotFound" -> CacheSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCacheSecurityGroupState" -> InvalidCacheSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterCombination" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValue" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElastiCacheException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAuthorizeCacheSecurityGroupIngressOperationBody(builder: AuthorizeCacheSecurityGroupIngressResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AuthorizeCacheSecurityGroupIngress")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // CacheSecurityGroup com.amazonaws.elasticache#AuthorizeCacheSecurityGroupIngressResult$CacheSecurityGroup
            "CacheSecurityGroup" -> builder.cacheSecurityGroup = deserializeCacheSecurityGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
