// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticache.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the subnet associated with a cluster. This parameter refers to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with ElastiCache.
 */
public class Subnet private constructor(builder: Builder) {
    /**
     * The Availability Zone associated with the subnet.
     */
    public val subnetAvailabilityZone: aws.sdk.kotlin.services.elasticache.model.AvailabilityZone? = builder.subnetAvailabilityZone
    /**
     * The unique identifier for the subnet.
     */
    public val subnetIdentifier: kotlin.String? = builder.subnetIdentifier
    /**
     * The outpost ARN of the subnet.
     */
    public val subnetOutpost: aws.sdk.kotlin.services.elasticache.model.SubnetOutpost? = builder.subnetOutpost
    /**
     * Either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 to 7.1 or Memcached engine version 1.6.6 and above on all instances built on the [Nitro system](http://aws.amazon.com/ec2/nitro/).
     */
    public val supportedNetworkTypes: List<NetworkType>? = builder.supportedNetworkTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticache.model.Subnet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Subnet(")
        append("subnetAvailabilityZone=$subnetAvailabilityZone,")
        append("subnetIdentifier=$subnetIdentifier,")
        append("subnetOutpost=$subnetOutpost,")
        append("supportedNetworkTypes=$supportedNetworkTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = subnetAvailabilityZone?.hashCode() ?: 0
        result = 31 * result + (subnetIdentifier?.hashCode() ?: 0)
        result = 31 * result + (subnetOutpost?.hashCode() ?: 0)
        result = 31 * result + (supportedNetworkTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Subnet

        if (subnetAvailabilityZone != other.subnetAvailabilityZone) return false
        if (subnetIdentifier != other.subnetIdentifier) return false
        if (subnetOutpost != other.subnetOutpost) return false
        if (supportedNetworkTypes != other.supportedNetworkTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticache.model.Subnet = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Availability Zone associated with the subnet.
         */
        public var subnetAvailabilityZone: aws.sdk.kotlin.services.elasticache.model.AvailabilityZone? = null
        /**
         * The unique identifier for the subnet.
         */
        public var subnetIdentifier: kotlin.String? = null
        /**
         * The outpost ARN of the subnet.
         */
        public var subnetOutpost: aws.sdk.kotlin.services.elasticache.model.SubnetOutpost? = null
        /**
         * Either `ipv4` | `ipv6` | `dual_stack`. IPv6 is supported for workloads using Valkey 7.2 and above, Redis OSS engine version 6.2 to 7.1 or Memcached engine version 1.6.6 and above on all instances built on the [Nitro system](http://aws.amazon.com/ec2/nitro/).
         */
        public var supportedNetworkTypes: List<NetworkType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticache.model.Subnet) : this() {
            this.subnetAvailabilityZone = x.subnetAvailabilityZone
            this.subnetIdentifier = x.subnetIdentifier
            this.subnetOutpost = x.subnetOutpost
            this.supportedNetworkTypes = x.supportedNetworkTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticache.model.Subnet = Subnet(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.AvailabilityZone] inside the given [block]
         */
        public fun subnetAvailabilityZone(block: aws.sdk.kotlin.services.elasticache.model.AvailabilityZone.Builder.() -> kotlin.Unit) {
            this.subnetAvailabilityZone = aws.sdk.kotlin.services.elasticache.model.AvailabilityZone.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticache.model.SubnetOutpost] inside the given [block]
         */
        public fun subnetOutpost(block: aws.sdk.kotlin.services.elasticache.model.SubnetOutpost.Builder.() -> kotlin.Unit) {
            this.subnetOutpost = aws.sdk.kotlin.services.elasticache.model.SubnetOutpost.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
